package com.aemforms.icdrafts.core.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.Servlet;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

import com.adobe.fd.ccm.ccr.ccrDocumentInstance.api.exception.CCRDocumentException;
import com.adobe.fd.ccm.ccr.ccrDocumentInstance.api.model.CCRDocumentInstance;
import com.adobe.fd.ccm.ccr.ccrDocumentInstance.api.services.CCRDocumentInstanceService;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;


@Component(service = { Servlet.class }, property = { "sling.servlet.methods=get", "sling.servlet.paths=/bin/getdrafts" })
public class GetDraftLetters extends SlingSafeMethodsServlet  {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	@Reference
	CCRDocumentInstanceService saveICDraft;
	
	protected void doGet(SlingHttpServletRequest request,  SlingHttpServletResponse response)
	{
		List<CCRDocumentInstance>listOfDrafts = new ArrayList<CCRDocumentInstance>();
		JsonArray draftLetters = new JsonArray();
		try {
			listOfDrafts = saveICDraft.getAll(null,null,null,null);
			for(int i=0;i<listOfDrafts.size();i++)
			{
				JsonObject draftLetter = new JsonObject();
				CCRDocumentInstance draftInstance = listOfDrafts.get(i);
				draftLetter.addProperty("documentID",draftInstance.getDocumentId());
				draftLetter.addProperty("draftID", draftInstance.getId());
				draftLetter.addProperty("draftName", draftInstance.getName());
				draftLetters.add(draftLetter);
			}
			System.out.println(draftLetters.toString());
			System.out.println("The number of saved instances are"+listOfDrafts.size());
			response.setContentType("text/plain");
			response.setHeader("Cache-Control", "nocache");
			response.setCharacterEncoding("utf-8");
			System.out.println(draftLetters.toString());
			PrintWriter pw = null;
			pw = response.getWriter();
			pw.println(draftLetters);
			pw.flush();
			
			
			
		} catch (CCRDocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
