package com.aemforms.icdrafts.core;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.sql.DataSource;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.ccm.ccr.ccrDocumentInstance.api.exception.CCRDocumentException;
import com.adobe.fd.ccm.ccr.ccrDocumentInstance.api.model.CCRDocumentInstance;
import com.adobe.fd.ccm.ccr.ccrDocumentInstance.api.services.CCRDocumentInstanceService;



@Component(service = CCRDocumentInstanceService.class, immediate = true)
public class SaveICDraft implements CCRDocumentInstanceService {
	@Reference(target = "(&(objectclass=javax.sql.DataSource)(datasource.name=SaveAndContinue))")
	private DataSource dataSource;
	private static final Logger log = LoggerFactory.getLogger(SaveICDraft.class);
	
	public Connection getConnection() {
		log.debug("Getting Connection ");
		Connection con = null;
		try {

			con = dataSource.getConnection();
			return con;
		} catch (Exception e) {
			log.debug("not able to get connection "+e.getMessage());
			
		}
		return null;
	}


	@Override
	public CCRDocumentInstance get(String draftID) throws CCRDocumentException {
		
		String selectStatement = "Select documentID from aemformstutorial.icdrafts where draftID='"+draftID+"'";
		log.debug("The select statement is "+selectStatement);
		Connection connection = getConnection();
		Statement statement = null;
		String documentID = "";
		try
			{
				statement = connection.createStatement();
				ResultSet rs = statement.executeQuery(selectStatement);
				while(rs.next())
					{
						documentID =  rs.getString("documentID");
						
					}
			} 
			catch (SQLException e)
			{
				log.debug("The error is "+e.getMessage());
			}
		finally {
			if(statement!=null)
			{
				try {
					statement.close();
				} catch (SQLException e) {
					
					log.debug("Error in closing"+e.getMessage());
				}
			}
			if(connection!=null)
			{
				try {
					connection.close();
				} catch (SQLException e) {
					log.debug("Error in closing"+e.getMessage());
					
				}
			}
		}
		//Document draftData = new Document(new File("c:\\icdrafts\\"+draftID+".xml"));
		Document draftData = new Document(new File(draftID+".xml"));
		CCRDocumentInstance draftInstance = new CCRDocumentInstance(draftData, "abc", documentID, CCRDocumentInstance.Status.DRAFT);
		draftInstance.setId(draftID);
		return draftInstance;
	}

	@Override
	public List<CCRDocumentInstance> getAll(String arg0, Date arg1, Date arg2, Map<String, Object> arg3) throws CCRDocumentException
	{
		String selectStatement = "Select * from aemformstutorial.icdrafts where owner = 'admin'";
		Connection connection = getConnection();
		Statement statement = null;
		String documentID = "";
		List<CCRDocumentInstance>listOfDrafts = new ArrayList<CCRDocumentInstance>();
		String draftID;
		String savedInstanceName="";
		try {
				statement = connection.createStatement();
				ResultSet rs = statement.executeQuery(selectStatement);
				while(rs.next())
				{
					documentID =  rs.getString("documentID");
					draftID = rs.getString("draftID");
					savedInstanceName = rs.getString("name");
					//Document draftData = new Document(new File("c:\\icdrafts\\"+draftID+".xml"));
					Document draftData = new Document(new File(draftID+".xml"));
					CCRDocumentInstance draftLetter = new CCRDocumentInstance(draftData, savedInstanceName, documentID,CCRDocumentInstance.Status.DRAFT);
					draftLetter.setId(draftID);
					listOfDrafts.add(draftLetter);
				}
			} 
			catch (SQLException e)
				{
					log.debug("The error is "+e.getMessage());
				}
			finally
				{
					if(statement!=null)
						{
							try
								{
									statement.close();
								}
							catch (SQLException e)
								{
									log.debug("error in closing statement"+e.getMessage());
								}
						}
					if(connection!=null)
						{
							try
								{
									connection.close();
								}
							catch (SQLException e)
								{
									log.debug("error in closing connection"+e.getMessage());
								}
						}
					}
		
		return listOfDrafts;
	}

	@Override
	public String save(CCRDocumentInstance letterToSave) throws CCRDocumentException {
		String insertRowSQL = "INSERT INTO aemformstutorial.icdrafts(draftID,documentID,status,owner,name) VALUES(?,?,?,?,?)";
		log.debug(" in save IC Draft"+letterToSave.getDocumentId()+letterToSave.getName());
		UUID uuid = UUID.randomUUID();
		String uuidString = uuid.toString();
		Connection connection = getConnection();
		PreparedStatement pstmt = null;
		Document icData = letterToSave.getData();
		try
		{
			pstmt = connection.prepareStatement(insertRowSQL);
			pstmt.setString(1, uuidString);
			pstmt.setString(2, letterToSave.getDocumentId());
			pstmt.setString(3,"DRAFT");
			pstmt.setString(4,letterToSave.getCreatedBy());
			pstmt.setString(5,letterToSave.getName());
			//icData.copyToFile(new File("c:\\icdrafts\\"+uuidString+".xml"));
			icData.copyToFile(new File(uuidString+".xml"));
			log.debug("Executing the insert statment  " + pstmt.executeUpdate());
			connection.commit();
		}
		catch (IOException | SQLException e)
		{
			log.debug("The error is "+e.getMessage());
		}
		finally
		{
			if(pstmt!=null)
				{
					try {
							pstmt.close();
						} catch (SQLException e)
							{
								log.debug("Error in closing prepared statment"+e.getMessage());
							}
			}
			if(connection!= null)
			{
				try
						{
							log.debug("Closing the connection in Save Letter Draft");
							connection.close();
						}
				catch(SQLException e)
						{
							log.debug("Error in closing connection" +e.getMessage());
						}
			}
			
		}
		
	return uuidString;
	}

	@Override
	public void update(CCRDocumentInstance letterInstanceToUpdate) throws CCRDocumentException {
		Document icData = letterInstanceToUpdate.getData();
		String draftID = letterInstanceToUpdate.getId();
		log.debug("updating letter instance with draft id =  "+draftID);
		try
			{
				icData.copyToFile(new File(draftID+".xml"));
			} 
		catch (IOException e)
			{
				log.debug("Error updating "+e.getMessage());;
			}
		
	}

}
