package com.aemformscs.formsdocumentservices;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class DocumentGeneration {
	public String SAVE_LOCATION = "c:\\aspire1";
	private static final String BUCKET = "author-p133654-e1305513";
	private static final String HOST = "https://" + BUCKET + ".adobeaemcloud.com";


	private static final Logger logger = LoggerFactory.getLogger(DocumentGeneration.class);

	public void extractPDFProperties(String accessToken,String endPoint) {

		String host = "https://" +BUCKET + ".adobeaemcloud.com";
		String url = host + endPoint;
		ClassLoader classLoader = DocumentGeneration.class.getClassLoader();
		URL pdfFile = classLoader.getResource("pdffiles/withoutusagerights.pdf");
		File fileToInspect = new File(pdfFile.getPath());
		MultipartEntityBuilder builder = MultipartEntityBuilder.create();
		byte[] fileContent;
		CloseableHttpClient httpClient = null;
		CloseableHttpResponse response = null;
		try {
			HttpPost httpPost = new HttpPost(url);
			httpPost.addHeader("Authorization", "Bearer " + accessToken);
			httpPost.addHeader("X-Adobe-Accept-Experimental", "1");

			fileContent = FileUtils.readFileToByteArray(fileToInspect);
			builder.addBinaryBody("document", fileContent, ContentType.create("application/pdf"), "BenefitOverview.pdf");

			HttpEntity entity = builder.build();
			httpPost.setEntity(entity);

			 httpClient = HttpClients.createDefault();
			 response = httpClient.execute(httpPost);
			String responseBody = EntityUtils.toString(response.getEntity());
			logger.info("Response Body: " + responseBody);

		} catch (IOException e) {

			logger.error(e.getMessage());
		}
		finally {
			try {

				if (response != null) response.close();
				if (httpClient != null) httpClient.close();
			} catch (IOException e) {
				logger.error("Error closing resources", e);
			}
		}
	}


	public void applyUsageRights(String accessToken,String endPoint) {

	        String host = "https://" + BUCKET + ".adobeaemcloud.com";
	        String url = host + endPoint;
	        String usageRights = "{\"comments\":true,\"embeddedFiles\":true,\"formFillIn\":true,\"formDataExport\":true}";

	        logger.info("Request URL: {}", url);
	        logger.info("Access Token: {}", accessToken);

	        ClassLoader classLoader = DocumentGeneration.class.getClassLoader();
	        URL pdfFile = classLoader.getResource("pdffiles/withoutusagerights.pdf");

	        if (pdfFile == null) {
	            logger.error("PDF file not found!");
	            return;
	        }

	        File fileToApplyRights = new File(pdfFile.getPath());
	        CloseableHttpClient httpClient = null;
	        CloseableHttpResponse response = null;
	        InputStream generatedPDF = null;
	        FileOutputStream outputStream = null;
	        
	        try {
	            httpClient = HttpClients.createDefault();
	            byte[] fileContent = FileUtils.readFileToByteArray(fileToApplyRights);
	            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
	            builder.addBinaryBody("document", fileContent, ContentType.create("application/pdf"),fileToApplyRights.getName());
	            builder.addTextBody("usageRights", usageRights, ContentType.APPLICATION_JSON);
	            
	            HttpPost httpPost = new HttpPost(url);
	            httpPost.addHeader("Authorization", "Bearer " + accessToken);
	            httpPost.addHeader("X-Adobe-Accept-Experimental", "1");
	            httpPost.setEntity(builder.build());
	            
	            response = httpClient.execute(httpPost);
	            generatedPDF = response.getEntity().getContent();
	            byte[] bytes = IOUtils.toByteArray(generatedPDF);

				outputStream = new FileOutputStream(SAVE_LOCATION + File.separator + "ReaderExtended.pdf");
	            outputStream.write(bytes);
				logger.info("ReaderExtended File is  saved at "+SAVE_LOCATION);
	        } catch (IOException e) {
	            logger.error("Error applying usage rights", e);
	        } finally {
	            try {
	                if (generatedPDF != null) generatedPDF.close();
	                if (response != null) response.close();
	                if (httpClient != null) httpClient.close();
	                if (outputStream != null) outputStream.close();
	            } catch (IOException e) {
	                logger.error("Error closing resources", e);
	            }
	        }
	    }

	public void exportData(String accessToken)
	{
		 String bucket = "author-p133654-e1305513";
	        String host = "https://" + bucket + ".adobeaemcloud.com";
	        String pathname = "/adobe/document/extract/pdfproperties";
	        String url = host + pathname;
	        System.out.println(url);
	        System.out.println(accessToken);
	        ClassLoader classLoader = DocumentGeneration.class.getClassLoader();
			URL pdfFile = classLoader.getResource("pdffiles/withoutusagerights.pdf");
			File fileToInspect = new File(pdfFile.getPath());
			MultipartEntityBuilder builder = MultipartEntityBuilder.create();
			byte[] fileContent;
			
			try {
				HttpPost httpPost = new HttpPost(url);
				httpPost.addHeader("Authorization", "Bearer "+ accessToken);
				//httpPost.addHeader("Content-Type", "multipart/form-data");
			    httpPost.addHeader("X-Adobe-Accept-Experimental", "1");
				
				fileContent = FileUtils.readFileToByteArray(fileToInspect);
				builder.addBinaryBody("document", fileContent, ContentType.create("application/pdf"), "BenefitOverview.pdf");
				
				HttpEntity entity = builder.build();
				httpPost.setEntity(entity);
				CloseableHttpClient httpclient = HttpClients.createDefault();
				CloseableHttpResponse response = httpclient.execute(httpPost);
				System.out.println(response.getStatusLine().getStatusCode());
				int statusCode = response.getStatusLine().getStatusCode();
	            String responseBody = EntityUtils.toString(response.getEntity());

	            System.out.println("Response Code: " + statusCode);
	            System.out.println("Response Body: " + responseBody);

			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	  		

			
			
	}


	public void mergeDataWithXdpTemplate(String accessToken,String endPoint) {

		String host = "https://" + BUCKET + ".adobeaemcloud.com";
		String pathname = "/adobe/document/generate/pdfform";
		String postURL = host + endPoint;
		HttpPost httpPost = new HttpPost(postURL);
		httpPost.addHeader("Authorization", "Bearer " + accessToken);
		httpPost.addHeader("X-Adobe-Accept-Experimental", "1");

		ClassLoader classLoader = DocumentGeneration.class.getClassLoader();
		URL templateFile = classLoader.getResource("templates/custom_fonts.xdp");

		if (templateFile == null) {
			System.err.println("Template file not found!");
			return;
		}

		File xdpTemplate = new File(templateFile.getPath());
		URL url = classLoader.getResource("datafiles");

		if (url == null) {
			System.err.println("Data files directory not found!");
			return;
		}

		File[] files = new File(url.getPath()).listFiles();

		if (files == null || files.length == 0) {
			System.err.println("No data files found!");
			return;
		}

		try (CloseableHttpClient httpclient = HttpClients.createDefault()) {
			for (File file : files) {
				MultipartEntityBuilder builder = MultipartEntityBuilder.create();
				builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
				builder.addBinaryBody("data", file);
				builder.addBinaryBody("template", xdpTemplate);
				builder.addBinaryBody("options", GetOptions.getPDFOptions().getBytes(), ContentType.APPLICATION_JSON, "options");

				HttpEntity entity = builder.build();
				httpPost.setEntity(entity);

				try (CloseableHttpResponse response = httpclient.execute(httpPost);
					 InputStream generatedPDF = response.getEntity().getContent()) {

					byte[] bytes = IOUtils.toByteArray(generatedPDF);
					File saveLocation = new File(SAVE_LOCATION);

					if (!saveLocation.exists()) {
						saveLocation.mkdirs();
					}

					File outputFile = new File(SAVE_LOCATION + File.separator + file.getName().replace("xml", "pdf"));

					try (FileOutputStream outputStream = new FileOutputStream(outputFile)) {
						outputStream.write(bytes);
					}
				} catch (Exception e) {
					System.err.println("Error processing file " + file.getName() + ": " + e.getMessage());
				}
			}
		} catch (Exception e) {
			System.err.println("Error in HTTP client: " + e.getMessage());
		}

		System.out.println("Done generating " + files.length + " files");
	}




}
