package com.aemformscs.formsdocumentservices;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
	private static final Logger logger = LoggerFactory.getLogger(Main.class);

	public static void main(String[] args) {
		try {
			String accessToken = new AccessTokenService().getAccessToken();
			DocumentGeneration docGen = new DocumentGeneration();

			docGen.applyUsageRights(accessToken, "/adobe/document/assure/usagerights");

			// Uncomment as needed
			// docGen.extractPDFProperties(accessToken, "/adobe/document/extract/pdfproperties");
			// docGen.mergeDataWithXdpTemplate(accessToken, "/adobe/document/generate/pdfform");

		} catch (Exception e) {
			logger.error("Error occurred: {}", e.getMessage(), e);
		}
	}
}