/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.formattachments.core;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Zip form attachments", "service.vendor=Adobe Systems", "process.label=Zip form attachments"})
public class ZipFormAttachments
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(ZipFormAttachments.class);
    @Reference
    QueryBuilder queryBuilder;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap processArguments) throws WorkflowException {
        String payloadPath = workItem.getWorkflowData().getPayload().toString();
        log.debug("The payload path  is" + payloadPath);
        MetaDataMap metaDataMap = workItem.getWorkflow().getWorkflowData().getMetaDataMap();
        Session session = (Session)workflowSession.adaptTo(Session.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", workItem.getWorkflowData().getPayload().toString() + "/" + ((String)processArguments.get("PROCESS_ARGS", (Object)"string")).toString());
        map.put("type", "nt:file");
        Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), (Session)workflowSession.adaptTo(Session.class));
        query.setStart(0L);
        query.setHitsPerPage(20L);
        SearchResult result = query.getResult();
        log.debug("Get result hits " + result.getHits().size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(baos);
        int no_of_attachments = result.getHits().size();
        for (Hit hit : result.getHits()) {
            try {
                int nRead;
                String attachmentPath = hit.getPath();
                log.debug("The hit path is" + hit.getPath());
                Node attachmentNode = session.getNode(attachmentPath + "/jcr:content");
                InputStream attachmentStream = attachmentNode.getProperty("jcr:data").getBinary().getStream();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[1024];
                while ((nRead = attachmentStream.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                byte[] byteArray = buffer.toByteArray();
                ZipEntry zipEntry = new ZipEntry(hit.getTitle());
                zipOut.putNextEntry(zipEntry);
                zipOut.write(byteArray);
                zipOut.closeEntry();
            }
            catch (Exception e) {
                log.debug("The error message is " + e.getMessage());
            }
        }
        try {
            zipOut.close();
            Node payloadNode = session.getNode(payloadPath);
            Node zippedFileNode = payloadNode.addNode("zipped_attachments.zip", "nt:file");
            Node resNode = zippedFileNode.addNode("jcr:content", "nt:resource");
            ValueFactory valueFactory = session.getValueFactory();
            Document zippedDocument = new Document(baos.toByteArray());
            Binary contentValue = valueFactory.createBinary(zippedDocument.getInputStream());
            metaDataMap.put((Object)"no_of_attachments", (Object)no_of_attachments);
            workflowSession.updateWorkflowData(workItem.getWorkflow(), workItem.getWorkflow().getWorkflowData());
            log.debug("Updated workflow");
            resNode.setProperty("jcr:data", contentValue);
            session.save();
            zippedDocument.close();
        }
        catch (IOException | RepositoryException e) {
            log.debug("Error in closing zipout" + e.getMessage());
        }
    }
}

