/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.formattachments.core;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import java.io.InputStream;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.Session;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=PopulateListOfDocuments", "service.vendor=Adobe Systems", "process.label=PopulateListOfDocuments"})
public class PopulateListOfDocuments
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(PopulateListOfDocuments.class);
    @Reference
    QueryBuilder queryBuilder;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap processArguments) throws WorkflowException {
        String payloadPath = workItem.getWorkflowData().getPayload().toString();
        log.debug("The payload path  is" + payloadPath);
        MetaDataMap metaDataMap = workItem.getWorkflow().getWorkflowData().getMetaDataMap();
        Session session = (Session)workflowSession.adaptTo(Session.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", workItem.getWorkflowData().getPayload().toString() + "/" + ((String)processArguments.get("PROCESS_ARGS", (Object)"string")).toString());
        map.put("type", "nt:file");
        Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), (Session)workflowSession.adaptTo(Session.class));
        query.setStart(0L);
        query.setHitsPerPage(20L);
        SearchResult result = query.getResult();
        log.debug("Get result hits " + result.getHits().size());
        int no_of_attachments = result.getHits().size();
        Document[] listOfDocuments = new Document[no_of_attachments];
        String[] attachmentNames = new String[no_of_attachments];
        int i = 0;
        for (Hit hit : result.getHits()) {
            try {
                String attachmentPath = hit.getPath();
                log.debug("The hit path is" + hit.getPath());
                Node attachmentNode = session.getNode(attachmentPath + "/jcr:content");
                InputStream attachmentStream = attachmentNode.getProperty("jcr:data").getBinary().getStream();
                listOfDocuments[i] = new Document(attachmentStream);
                attachmentNames[i] = new String(hit.getTitle());
                log.debug("Added " + hit.getTitle() + "to the list");
                ++i;
            }
            catch (Exception e) {
                log.debug("The error message is " + e.getMessage());
            }
        }
        metaDataMap.put((Object)"no_of_attachments", (Object)no_of_attachments);
        metaDataMap.put((Object)"listOfDocuments", (Object)listOfDocuments);
        metaDataMap.put((Object)"attachmentNames", (Object)attachmentNames);
        log.debug("Updated workflow");
    }
}

