# Demo NodeJS App to Invoke AEM OpenAPI

This Node.js application demonstrates how to interact with [Adobe Experience Manager (AEM) OpenAPI](https://developer.adobe.com/experience-cloud/experience-manager-apis/guides/). 

In this example, it retrieves metadata for a specific asset using the AEM [Assets Author API](https://developer.adobe.com/experience-cloud/experience-manager-apis/api/experimental/assets/author/). The application uses OAuth 2.0 Client Credentials to authenticate with Adobe IMS and fetches an access token to invoke the API.

## Features

- **IMS Authentication**: Fetches an access token using OAuth 2.0 Client Credentials.
- **Asset Metadata Retrieval**: Invokes the AEM [Assets Author API](https://developer.adobe.com/experience-cloud/experience-manager-apis/api/experimental/assets/author/) to get metadata for a specific asset.

## Prerequisites

1. **Node.js**: Ensure you have Node.js installed (version 18.x or above is recommended).
2. **Adobe Developer Console**: Set up a project to generate `clientId` and `clientSecret`.
3. **Environment Variables**:
   - `CLIENT_ID`: Adobe IMS Client ID.
   - `CLIENT_SECRET`: Adobe IMS Client Secret.
   - `SCOPES`: The required scopes for the API.
4. **AEM as a Cloud Service**: Ensure you have access to an AEM as a Cloud Service instance.
    - `bucket`: The AEM instance bucket name, for example, `author-p63947-e1420429`.
    - `assetId`: The asset ID for which you want to retrieve metadata, for example, `urn:aaid:aem:9c09ff70-9ee8-4b14-a5fa-ec37baa0d1b3`.

## Installation

1. Download or clone the repository.

1. Install dependencies:

```bash
$ npm install
```

1. Set up a `.env` file with the following environment variables:

```plaintext
CLIENT_ID=your-client-id
CLIENT_SECRET=your-client-secret
SCOPES=your-required-scopes
```

1. Update the following variables in `src/index.js` with your specific AEM as a Cloud Service instance details:

```javascript
const bucket = "author-p63947-e1420429"; // Replace with your AEM instance name
const assetId = "urn:aaid:aem:9c09ff70-9ee8-4b14-a5fa-ec37baa0d1b3"; // Replace with your asset ID
```

## Usage

Run the application:

```bash
$ node src/index.js
```

## What Happens?

1. The application fetches an access token from Adobe IMS.

1. It uses the access token to invoke the AEM Assets Author API.

1. The asset's metadata is fetched and displayed in the console.

## Important Information


- Ensure that your Adobe Developer Console project is properly configured for OAuth Server-to-Server authentication.

- Replace the placeholder values in the `.env` file and `index.js` with actual values specific to your setup.

## What's Next?

- Explore the [AEM OpenAPI documentation](https://developer.adobe.com/experience-cloud/experience-manager-apis/guides/) to learn more about the available APIs.

- Develop your own applications to interact with AEM OpenAPI.


