// Import the dotenv configuration to load environment variables from the .env file
import "dotenv/config";

// Import the fetch function to make HTTP requests
import fetch from "node-fetch";

// REPLACE THE FOLLOWING VALUES WITH YOUR OWN
const bucket = "<BUCKETNAME>"; // Bucket name is the AEM instance name (e.g. author-p63947-e1420428)
const assetId = "<ASSETID>"; // Asset ID is the unique identifier for the asset in AEM (e.g. urn:aaid:aem:a200faf1-6d12-4abc-bc16-1b9a21f870da). You can get it by inspecting the asset in browser's element inspector, look for data-id="urn:aaid:aem:..."


// Load environment variables for authentication
const clientId = process.env.CLIENT_ID; // Adobe IMS client ID
const clientSecret = process.env.CLIENT_SECRET; // Adobe IMS client secret
const scopes = process.env.SCOPES; // Scope for the API access

// Adobe IMS endpoint for obtaining an access token
const adobeIMSV3TokenEndpointURL =
"https://ims-na1.adobelogin.com/ims/token/v3";

// Function to obtain an access token from Adobe IMS
const getAccessToken = async () => {
    console.log("Getting access token from IMS"); // Log process initiation
    //console.log("Client ID: " + clientId); // Display client ID for debugging purposes

    // Configure the HTTP POST request to fetch the access token
    const options = {
        method: "POST",
        headers: {
        "Content-Type": "application/x-www-form-urlencoded", // Specify form data content type
        },
        // Send client ID, client secret, and scopes as the request body
        body: `grant_type=client_credentials&client_id=${clientId}&client_secret=${clientSecret}&scope=${scopes}`,
    };

    // Make the HTTP request to fetch the access token
    const response = await fetch(adobeIMSV3TokenEndpointURL, options);

    //console.log("Response status: " + response.status); // Log the HTTP status for debugging

    const responseJSON = await response.json(); // Parse the JSON response

    console.log("Access token received"); // Log success message

    // Return the access token
    return responseJSON.access_token;
};

// Function to retrieve metadata for a specific asset from AEM
const getAssetMetadat = async () => {
    // Fetch the access token using the getAccessToken function
    const accessToken = await getAccessToken();

    console.log("Getting asset metadata from AEM");

    // Invoke the Assets Author API to retrieve metadata for a specific asset
    const resp = await fetch(
        `https://${bucket}.adobeaemcloud.com/adobe/assets/${assetId}/metadata`, // Construct the URL with bucket and asset ID
        {
        method: "GET",
        headers: {
            "If-None-Match": "string", // Header to handle caching (not critical for this tutorial)
            "X-Adobe-Accept-Experimental": "1", // Header to enable experimental Adobe API features
            Authorization: "Bearer " + accessToken, // Provide the access token for authorization
            "X-Api-Key": clientId, // Include the OAuth S2S ClientId for identification
        },
        }
    );

    const data = await resp.json(); // Parse the JSON response

    console.log("Asset metadata received"); // Log success message
    console.log(data); // Display the retrieved metadata
};

// Call the getAssets function to start the process
getAssetMetadat();