/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.jsontoxml.core;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.jcr.Node;
import javax.jcr.Session;
import org.json.JSONObject;
import org.json.XML;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Convert JSON to XML", "service.vendor=Adobe Systems", "process.label=Convert JSON to XML"})
public class ConvertJsonPayloadToXML
implements WorkflowProcess {
    private final Logger log = LoggerFactory.getLogger(ConvertJsonPayloadToXML.class);

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap arg2) throws WorkflowException {
        this.log.debug("The process argument I got was ..." + ((String)arg2.get("PROCESS_ARGS", (Object)"string")).toString());
        String submittedDataFile = ((String)arg2.get("PROCESS_ARGS", (Object)"string")).toString();
        String payloadPath = workItem.getWorkflowData().getPayload().toString();
        this.log.debug("The payload in Convert JSON Payload to XML  " + workItem.getWorkflowData().getPayload().toString());
        String dataFilePath = payloadPath + "/" + submittedDataFile + "/jcr:content";
        Session session = (Session)workflowSession.adaptTo(Session.class);
        Node submittedJsonDataNode = null;
        try {
            String inputStr;
            submittedJsonDataNode = session.getNode(dataFilePath);
            InputStream jsonDataStrem = submittedJsonDataNode.getProperty("jcr:data").getBinary().getStream();
            BufferedReader streamReader = new BufferedReader(new InputStreamReader(jsonDataStrem, "UTF-8"));
            StringBuilder strBuilder = new StringBuilder();
            while ((inputStr = streamReader.readLine()) != null) {
                strBuilder.append(inputStr);
            }
            JSONObject submittedJson = new JSONObject(strBuilder.toString());
            this.log.debug(submittedJson.toString());
            String xmlString = XML.toString((Object)submittedJson);
            this.log.debug("The json converted to XML " + xmlString);
            MetaDataMap metaDataMap = workItem.getWorkflow().getWorkflowData().getMetaDataMap();
            metaDataMap.put((Object)"xmlData", (Object)xmlString);
        }
        catch (Exception e) {
            this.log.debug("The message is  " + e.getMessage());
        }
    }
}

