/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.assembletaskattachments.core;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.assembler.client.AssemblerOptionSpec;
import com.adobe.fd.assembler.client.AssemblerResult;
import com.adobe.fd.assembler.client.OperationException;
import com.adobe.fd.assembler.service.AssemblerService;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@Component(property={"service.description=AssembleTaskAttachments", "service.vendor=Adobe Systems", "process.label=Assemble Task Attachments"})
public class AssembleTaskAttachments
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(AssembleTaskAttachments.class);
    @Reference
    QueryBuilder queryBuilder;
    @Reference
    AssemblerService assemblerService;

    public Document createDDXFromMapOfDocuments(Map<String, Object> mapOfDocuments) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        org.w3c.dom.Document ddx = null;
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            ddx = docBuilder.newDocument();
            Element rootElement = ddx.createElementNS("http://ns.adobe.com/DDX/1.0/", "DDX");
            ddx.appendChild(rootElement);
            Element pdfResult = ddx.createElement("PDF");
            pdfResult.setAttribute("result", "GeneratedDocument.pdf");
            rootElement.appendChild(pdfResult);
            for (String key : mapOfDocuments.keySet()) {
                log.debug(key + " " + mapOfDocuments.get(key));
                Element pdfSourceElement = ddx.createElement("PDF");
                pdfSourceElement.setAttribute("source", key);
                pdfResult.appendChild(pdfSourceElement);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return this.orgw3cDocumentToAEMFDDocument(ddx);
    }

    public Document orgw3cDocumentToAEMFDDocument(org.w3c.dom.Document xmlDocument) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(xmlDocument);
        log.debug("$$$$In orgW3CDocumentToAEMFDDocument method");
        StreamResult outputTarget = new StreamResult(outputStream);
        try {
            TransformerFactory.newInstance().newTransformer().transform(source, outputTarget);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        ByteArrayInputStream is1 = new ByteArrayInputStream(outputStream.toByteArray());
        Document xmlAEMFDDocument = new Document((InputStream)is1);
        return xmlAEMFDDocument;
    }

    public Document assembleDocuments(Map<String, Object> mapOfDocuments, Document ddxDocument) {
        AssemblerOptionSpec aoSpec = new AssemblerOptionSpec();
        aoSpec.setFailOnError(true);
        AssemblerResult ar = null;
        try {
            ar = this.assemblerService.invoke(ddxDocument, mapOfDocuments, aoSpec);
        }
        catch (OperationException e) {
            e.printStackTrace();
        }
        return (Document)ar.getDocuments().get("GeneratedDocument.pdf");
    }

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap arg2) throws WorkflowException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", workItem.getWorkflowData().getPayload().toString());
        System.out.println("The payload path is " + workItem.getWorkflowData().getPayload().toString());
        map.put("type", "nt:file");
        Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), (Session)workflowSession.adaptTo(Session.class));
        query.setStart(0L);
        query.setHitsPerPage(20L);
        SearchResult result = query.getResult();
        System.out.println("Get result hits " + result.getHits().size());
        Node xmlDataNode = null;
        HashMap<String, Object> mapOfDocuments = new HashMap<String, Object>();
        for (Hit hit : result.getHits()) {
            try {
                String path = hit.getPath();
                System.out.println("The title " + hit.getTitle() + " path " + path);
                if (!hit.getTitle().endsWith("pdf")) continue;
                xmlDataNode = ((Session)workflowSession.adaptTo(Session.class)).getNode(path + "/jcr:content");
                InputStream xmlDataStream = xmlDataNode.getProperty("jcr:data").getBinary().getStream();
                Document attachmentDocument = new Document(xmlDataStream);
                mapOfDocuments.put(hit.getTitle(), attachmentDocument);
                System.out.println("@@@@Added to map@@@@@ " + hit.getTitle());
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        Document ddxDocument = this.createDDXFromMapOfDocuments(mapOfDocuments);
        Document assembledDocument = this.assembleDocuments(mapOfDocuments, ddxDocument);
        try {
            assembledDocument.copyToFile(new File("assembledforlee.pdf"));
            Session session = (Session)workflowSession.adaptTo(Session.class);
            Node payloadNode = ((Session)workflowSession.adaptTo(Session.class)).getNode(workItem.getWorkflowData().getPayload().toString());
            System.out.println("The payload Path is " + payloadNode.getPath());
            Node assembledPDFNode = payloadNode.addNode("assembled-pdf.pdf", "nt:file");
            Node jcrContentNode = assembledPDFNode.addNode("jcr:content", "nt:resource");
            Binary binary = session.getValueFactory().createBinary(assembledDocument.getInputStream());
            jcrContentNode.setProperty("jcr:data", binary);
            System.out.println("Saved !!!!!!");
            session.save();
        }
        catch (IOException | RepositoryException e) {
            e.printStackTrace();
        }
    }
}

