/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.batchgenerationapisamples.core.servlets;

import com.adobe.fd.ccm.multichannel.batch.api.builder.BatchConfigBuilder;
import com.adobe.fd.ccm.multichannel.batch.api.factory.BatchComponentBuilderFactory;
import com.adobe.fd.ccm.multichannel.batch.api.model.BatchConfig;
import com.adobe.fd.ccm.multichannel.batch.api.model.BatchInput;
import com.adobe.fd.ccm.multichannel.batch.api.model.BatchResult;
import com.adobe.fd.ccm.multichannel.batch.api.model.BatchType;
import com.adobe.fd.ccm.multichannel.batch.api.model.RecordResult;
import com.adobe.fd.ccm.multichannel.batch.api.model.RenditionResult;
import com.adobe.fd.ccm.multichannel.batch.api.service.BatchGeneratorService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.paths=/bin/icBatchServlet"})
public class ICBatchServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ICBatchServlet.class);
    @Reference
    private BatchGeneratorService batchGeneratorService;
    @Reference
    private BatchComponentBuilderFactory batchBuilderFactory;

    public void doPost(SlingHttpServletRequest req, SlingHttpServletResponse resp) {
        try {
            this.executeBatch(req, resp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void executeBatch(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws Exception {
        String str;
        JSONArray inputJSONArray = new JSONArray();
        String filePath = req.getParameter("filePath");
        String templatePath = req.getParameter("templatePath");
        String saveLocation = req.getParameter("saveLocation");
        String recordID = req.getParameter("recordId");
        String channelType = req.getParameter("channelType");
        log.debug("The record id " + recordID + "channel Type is " + channelType + "filePath " + filePath + "templatePath " + templatePath + "saveLocation " + saveLocation);
        FileInputStream jsonStream = new FileInputStream(filePath);
        InputStreamReader isReader = new InputStreamReader(jsonStream);
        BufferedReader reader = new BufferedReader(isReader);
        StringBuffer sb = new StringBuffer();
        while ((str = reader.readLine()) != null) {
            sb.append(str);
        }
        String data = sb.toString();
        reader.close();
        try {
            JSONObject inputJSON = new JSONObject(data);
            inputJSONArray.put((Object)inputJSON);
        }
        catch (Exception e) {
            try {
                JSONArray inputArray = new JSONArray(data);
                for (int i = 0; i < inputArray.length(); ++i) {
                    inputJSONArray.put((Object)inputArray.getJSONObject(i));
                }
            }
            catch (Exception ex) {
                throw new Exception("Invalid JSON Data. File name : " + filePath, ex);
            }
        }
        BatchInput batchInput = this.batchBuilderFactory.getBatchInputBuilder().setData(inputJSONArray).setTemplatePath(templatePath).build();
        BatchConfigBuilder batchConfigBuilder = this.batchBuilderFactory.getBatchConfigBuilder();
        batchConfigBuilder.setRecordPath(recordID);
        if (channelType.equalsIgnoreCase("Print")) {
            batchConfigBuilder.setBatchType(BatchType.PRINT);
            System.out.println("Print mode!!!!");
        }
        if (channelType.equalsIgnoreCase("Web")) {
            batchConfigBuilder.setBatchType(BatchType.WEB);
        }
        if (channelType.equalsIgnoreCase("Both")) {
            batchConfigBuilder.setBatchType(BatchType.WEB_AND_PRINT);
        }
        BatchConfig batchConfig = batchConfigBuilder.build();
        BatchResult batchResult = this.batchGeneratorService.generateBatch(batchInput, batchConfig);
        List recordList = batchResult.getRecordResults();
        JSONObject result = new JSONObject();
        for (RecordResult recordResult : recordList) {
            String recordId = recordResult.getRecordID();
            for (RenditionResult renditionResult : recordResult.getRenditionResults()) {
                File file;
                if (!renditionResult.isRecordPassed()) continue;
                InputStream output = renditionResult.getDocumentStream().getInputStream();
                result.put(recordId + "_" + renditionResult.getContentType(), (Object)output);
                if (this.getFileExtension(renditionResult.getContentType()).equalsIgnoreCase(".json")) {
                    file = new File(saveLocation + "\\" + recordId + this.getFileExtension(renditionResult.getContentType()));
                    ICBatchServlet.copyInputStreamToFile(output, file);
                    continue;
                }
                file = new File(saveLocation + "\\" + recordId + this.getFileExtension(renditionResult.getContentType()));
                ICBatchServlet.copyInputStreamToFile(output, file);
            }
        }
        PrintWriter writer = resp.getWriter();
        JSONObject resultObj = new JSONObject();
        resultObj.put("result", (Object)result);
        writer.write(resultObj.toString());
    }

    private static void copyInputStreamToFile(InputStream inputStream, File file) throws IOException {
        log.debug("Generating  " + file.getName());
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
    }

    private String getFileExtension(String contentType) {
        if (contentType.endsWith("application/json")) {
            return ".json";
        }
        return ".pdf";
    }
}

