package com.azuredemo.core.servlets;

import com.azuredemo.core.SaveAndFetchFromAzure.StoreAndFetchDataFromAzureStorage;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.Session;
import javax.servlet.Servlet;
import java.io.IOException;
import java.io.Serializable;

@Component(
        service={Servlet.class }
)

        @SlingServletResourceTypes(
                resourceTypes="azure/fetchchoices",
                methods= "GET",
                extensions="json"
                )


public class GetFieldChoices extends SlingAllMethodsServlet implements Serializable {
    private static final long serialVersionUID = 1L;
    private final  transient Logger log = LoggerFactory.getLogger(this.getClass());


    @Reference transient
    StoreAndFetchDataFromAzureStorage azurePortalBlobs;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {

        log.debug("The form path I got was "+request.getParameter("formPath"));

        Session session = request.getResourceResolver().adaptTo(Session.class);
        //azurePortalBlobs.getOptions(request.getParameter("formPath"),"es",session);

      String jsonArray =  azurePortalBlobs.getOptions(request.getParameter("formPath"),request.getParameter("fieldName"),session);
        try {
                response.setContentType("application/json");
                response.setCharacterEncoding("UTF-8");
                log.debug("The json response is "+jsonArray);
                response.getWriter().write(jsonArray);

           // response.getWriter().write(ja.toString());


        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
