package com.azuredemo.core.configuration.service.impl;

import com.azuredemo.core.configuration.service.AzurePortalConfigurationService;
import com.azuredemo.core.configuration.AzurePortalConfiguration;
import org.osgi.framework.Constants;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.Designate;
@Component(
        service = AzurePortalConfigurationService.class,
        immediate = true,
        property = {
                Constants.SERVICE_ID+ "=Azure Demo Portal Configuration",
                Constants.SERVICE_DESCRIPTION +"=This service reads values from Azure portal config"
        }
)
@Designate(ocd=AzurePortalConfiguration.class)
public class AzurePortalStorageConfigImpl implements AzurePortalConfigurationService {
    private AzurePortalConfiguration azurePortalConfiguration;
    @Activate
    protected void activate(AzurePortalConfiguration configuration) {

        this.azurePortalConfiguration = configuration;
    }

    @Override
    public String getStorageURI() {

        return azurePortalConfiguration.getStorageURI();
    }

    @Override
    public String getSASToken() {

        return azurePortalConfiguration.getSASToken();
    }

}
