package com.azuredemo.core.servlets;

import com.azuredemo.core.SaveAndFetchFromAzure.*;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.Session;
import javax.servlet.Servlet;
import java.io.IOException;
import java.io.Serializable;

@Component(
        service={Servlet.class }
)

@SlingServletResourceTypes(
        resourceTypes="azure/getSearchFields",
        methods= "GET",
        extensions="json"
)
public class GetMetaDataTags extends SlingAllMethodsServlet implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());


    @Reference transient
    StoreAndFetchDataFromAzureStorage azurePortalBlobs;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {

        String formPath = request.getParameter("formPath");

        log.debug("in the servlet to get searchable fields!!! "+formPath);


        Session session = request.getResourceResolver().adaptTo(Session.class);
        String jsonArray = azurePortalBlobs.getSearchableFields(formPath,session);

        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            log.debug("The json response is "+jsonArray);
        response.getWriter().write(jsonArray);

           // response.getWriter().write(ja.toString());


        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
