<!--
Copyright 2018 Adobe

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->
Separator (v1)
=========
Separator component written in HTL.

## Features

* Allows addition of a horizontal rule element for separating content sections.

### Use Object
The Separator component uses the `com.adobe.cq.wcm.core.components.models.Separator` Sling Model as its Use-object.

### Component Policy Configuration Properties
The following configuration properties are used:

1. `./isDecorative` - if set to `true`, then the separator will be ignored by assistive technology

## Edit Dialog Properties
The following properties are written to JCR for this Page component and are expected to be available as `Resource` properties:

1. `./id` - defines the component HTML ID attribute.
2. `./isDecorative` - if set to `true`, then the separator will be ignored by assistive technology

## BEM Description
```
BLOCK cmp-separator
    ELEMENT cmp-separator__horizontal-rule
```

## Information
* **Vendor**: Adobe
* **Version**: v1
* **Compatibility**: AEM 6.3
* **Status**: production-ready
* **Documentation**: [https://www.adobe.com/go/aem\_cmp\_separator\_v1](https://www.adobe.com/go/aem_cmp_separator_v1)
* **Component Library**: [https://www.adobe.com/go/aem\_cmp\_library\_separator](https://www.adobe.com/go/aem_cmp_library_separator)
