/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.cq.forms.core.components.models.form.BaseConstraint;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentUtils {
    private ComponentUtils() {
    }

    @NotNull
    public static String getEncodedPath(@NotNull String path) {
        return new String(Base64.getEncoder().encode(path.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    @NotNull
    public static boolean isAFContainer(@NotNull Resource resource) {
        String fieldType = (String)resource.getValueMap().get("fieldType", String.class);
        return "form".equals(fieldType);
    }

    public static Resource getFormContainer(Resource resource) {
        if (resource == null) {
            return null;
        }
        if (ComponentUtils.isAFContainer(resource)) {
            return resource;
        }
        return ComponentUtils.getFormContainer(resource.getParent());
    }

    @NotNull
    public static String translate(@NotNull String propertyValue, @NotNull String propertyName, @NotNull Resource resource, @Nullable I18n i18n) {
        return ComponentUtils.translate(propertyValue, propertyName, resource.getValueMap(), i18n);
    }

    @NotNull
    public static String translate(@NotNull String propertyValue, @NotNull String propertyName, @NotNull ValueMap valueMap, @Nullable I18n i18n) {
        String translatedValue = propertyValue;
        if (i18n != null) {
            translatedValue = GuideUtils.translateOrReturnOriginal((String)propertyValue, (String)propertyName, (I18n)i18n, (ValueMap)valueMap);
        }
        return translatedValue;
    }

    public static Date clone(@Nullable Date date) {
        return Optional.ofNullable(date).map(Date::getTime).map(Date::new).orElse(null);
    }

    @NotNull
    public static Object[] coerce(@NotNull BaseConstraint.Type type, @NotNull Object[] objArr) {
        block7: {
            block6: {
                block5: {
                    block4: {
                        if (type.equals((Object)BaseConstraint.Type.NUMBER)) break block4;
                        if (!type.equals((Object)BaseConstraint.Type.NUMBER_ARRAY)) break block5;
                    }
                    return Arrays.stream(objArr).filter(Objects::nonNull).map(Object::toString).map(Long::parseLong).toArray(Long[]::new);
                }
                if (type.equals((Object)BaseConstraint.Type.BOOLEAN)) break block6;
                if (!type.equals((Object)BaseConstraint.Type.BOOLEAN_ARRAY)) break block7;
            }
            return Arrays.stream(objArr).filter(Objects::nonNull).map(Object::toString).map(Boolean::parseBoolean).toArray(Boolean[]::new);
        }
        return ArrayUtils.clone((Object[])objArr);
    }

    public static ContentPolicy getPolicy(String contentPath, ResourceResolver resourceResolver) {
        ContentPolicy policy = null;
        Resource contentResource = resourceResolver.getResource(contentPath);
        ContentPolicyManager policyManager = (ContentPolicyManager)resourceResolver.adaptTo(ContentPolicyManager.class);
        if (contentResource != null && policyManager != null) {
            policy = policyManager.getPolicy(contentResource);
        }
        return policy;
    }

    public static Resource getFragmentContainer(ResourceResolver resourceResolver, @NotNull String fragmentPath) {
        String fragmentRef = fragmentPath;
        if (StringUtils.contains((CharSequence)fragmentPath, (CharSequence)"/content/dam/formsanddocuments")) {
            fragmentRef = GuideUtils.convertFMAssetPathToFormPagePath((String)fragmentPath);
        }
        return resourceResolver.getResource(fragmentRef + "/" + "jcr:content" + "/guideContainer");
    }

    public static boolean isFragmentComponent(Resource resource) {
        return resource != null && resource.getValueMap().get("fragmentPath", String.class) != null;
    }
}

