/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.internal.servlets;

import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.day.cq.wcm.foundation.forms.FormsManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDataSourceServlet
extends SlingSafeMethodsServlet {
    public static final String GRANITE_DATA = "granite:data";
    public static final String PN_TEXT = "text";
    public static final String PN_VALUE = "value";
    public static final String PN_QTIP = "qtip";

    @NotNull
    protected abstract ExpressionResolver getExpressionResolver();

    Config getConfig(SlingHttpServletRequest request) {
        Resource datasource = request.getResource().getChild(Config.DATASOURCE);
        if (datasource == null) {
            return null;
        }
        return new Config(datasource);
    }

    @Nullable
    protected String getParameter(@NotNull Config config, @NotNull String name, @NotNull SlingHttpServletRequest request, @Nullable String defaultValue) {
        String value = (String)config.get(name, String.class);
        if (value == null) {
            return defaultValue;
        }
        ExpressionHelper expressionHelper = new ExpressionHelper(this.getExpressionResolver(), request);
        return expressionHelper.getString(value);
    }

    @NotNull
    protected Resource createResource(@NotNull ResourceResolver resolver, @NotNull FormsManager.ComponentDescription desc) {
        Resource graniteData;
        Resource formMetaDataResource;
        ValueMapDecorator properties = new ValueMapDecorator(new HashMap());
        ArrayList<ValueMapResource> children = new ArrayList<ValueMapResource>();
        properties.put((Object)PN_TEXT, (Object)desc.getTitle());
        properties.put((Object)PN_VALUE, (Object)desc.getResourceType());
        if (StringUtils.isNotBlank((CharSequence)desc.getHint())) {
            properties.put((Object)PN_QTIP, (Object)desc.getHint());
        }
        if ((formMetaDataResource = resolver.getResource(desc.getResourceType())) != null && (graniteData = formMetaDataResource.getChild(GRANITE_DATA)) != null) {
            ValueMapDecorator graniteDataValueMap = new ValueMapDecorator((Map)graniteData.getValueMap());
            ValueMapResource childResource = new ValueMapResource(resolver, formMetaDataResource.getPath() + "/" + GRANITE_DATA, "sling:nonexisting", (ValueMap)graniteDataValueMap);
            children.add(childResource);
        }
        return new ValueMapResource(resolver, formMetaDataResource != null ? formMetaDataResource.getPath() : null, "sling:nonexisting", (ValueMap)properties, children);
    }
}

