/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.internal.models.v2.form;

import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.service.GuideSchemaType;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.GuideWCMUtils;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.forms.core.components.internal.models.v1.form.FormMetaDataImpl;
import com.adobe.cq.forms.core.components.models.form.Container;
import com.adobe.cq.forms.core.components.models.form.FormClientLibManager;
import com.adobe.cq.forms.core.components.models.form.FormContainer;
import com.adobe.cq.forms.core.components.models.form.FormMetaData;
import com.adobe.cq.forms.core.components.models.form.ThankYouOption;
import com.adobe.cq.forms.core.components.util.AbstractContainerImpl;
import com.adobe.cq.forms.core.components.util.ComponentUtils;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={FormContainer.class, ContainerExporter.class, ComponentExporter.class}, resourceType={"core/fd/components/form/container/v2/container", "core/fd/components/form/fragmentcontainer/v1/fragmentcontainer"})
@Exporter(name="jackson", extensions={"json"})
public class FormContainerImpl
extends AbstractContainerImpl
implements FormContainer {
    protected static final String RESOURCE_TYPE = "core/fd/components/form/container/v2/container";
    private static final String DOR_TYPE = "dorType";
    private static final String DOR_TEMPLATE_REF = "dorTemplateRef";
    private static final String DOR_TEMPLATE_TYPE = "dorTemplateType";
    private static final String FD_SCHEMA_TYPE = "fd:schemaType";
    private static final String FD_SCHEMA_REF = "fd:schemaRef";
    public static final String FD_FORM_DATA_ENABLED = "fd:formDataEnabled";
    @SlingObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private SlingHttpServletRequest request;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String thankYouMessage;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String thankYouOption;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String clientLibRef;
    protected String contextPath = "";
    private boolean formDataEnabled = false;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String themeClientLibRef;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String title;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String redirect;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String prefillService;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String data;

    @PostConstruct
    protected void initFormContainerModel() {
        if (this.request != null) {
            FormClientLibManager formClientLibManager;
            PageManager pageManager;
            Page resourcePage;
            this.contextPath = this.request.getContextPath();
            this.request.setAttribute("formContainerPath", (Object)this.getPath());
            Page currentPage = this.getCurrentPage();
            if (currentPage != null && (resourcePage = (pageManager = currentPage.getPageManager()).getContainingPage(this.resource)) != null && !StringUtils.equals((CharSequence)currentPage.getPath(), (CharSequence)resourcePage.getPath())) {
                this.request.setAttribute("referencedPage", (Object)resourcePage.getPath());
            }
            if ((formClientLibManager = (FormClientLibManager)this.request.adaptTo(FormClientLibManager.class)) != null && this.clientLibRef != null) {
                formClientLibManager.addClientLibRef(this.clientLibRef);
            }
        }
    }

    @Override
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @JsonIgnore
    public String getContextPath() {
        return this.contextPath != null ? this.contextPath : "";
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getThankYouMessage() {
        return this.translate("thankYouMessage", this.thankYouMessage);
    }

    @Override
    @JsonIgnore
    @Nullable
    public ThankYouOption getThankYouOption() {
        return ThankYouOption.fromString(this.thankYouOption);
    }

    @Override
    public String getAdaptiveFormVersion() {
        return "0.12.1";
    }

    @Override
    @Nullable
    public String getClientLibRef() {
        return this.clientLibRef;
    }

    @Override
    @Nullable
    public String getThemeClientLibRef() {
        return this.themeClientLibRef;
    }

    @Override
    @Nullable
    public String getSchemaRef() {
        return GuideContainer.from((Resource)this.resource).getSchemaRef();
    }

    @Override
    @Nullable
    public GuideSchemaType getSchemaType() {
        return GuideContainer.from((Resource)this.resource).getSchema();
    }

    @Override
    public FormMetaData getMetaData() {
        return new FormMetaDataImpl();
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public String getFormData() {
        return this.data;
    }

    @Override
    @JsonIgnore
    public String getEncodedCurrentPagePath() {
        if (this.getCurrentPage() != null) {
            return this.getId();
        }
        return null;
    }

    @Override
    public String getId() {
        if (this.getCurrentPage() != null) {
            if (GuideWCMUtils.isForms((String)this.getCurrentPage().getPath())) {
                return ComponentUtils.getEncodedPath(this.getCurrentPage().getPath());
            }
            return ComponentUtils.getEncodedPath(this.getPath());
        }
        return super.getId();
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getRedirectUrl() {
        String redirectURL = GuideUtils.getRedirectUrl((String)this.redirect, (String)this.getPath());
        if (StringUtils.isNotEmpty((CharSequence)this.redirect) && this.redirect.startsWith("/")) {
            redirectURL = this.getContextPath() + redirectURL;
        }
        return redirectURL;
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getPrefillService() {
        return this.prefillService;
    }

    @Override
    public String getAction() {
        if (this.getCurrentPage() != null) {
            return this.getContextPath() + "/adobe" + "/forms/af" + "/submit/" + this.getId();
        }
        return null;
    }

    @Override
    @JsonIgnore
    public String getDataUrl() {
        if (this.getCurrentPage() != null) {
            return this.getContextPath() + "/adobe" + "/forms/af" + "/data/" + ComponentUtils.getEncodedPath(this.getCurrentPage().getPath());
        }
        return null;
    }

    @Override
    public String getLang() {
        if (this.request != null) {
            return GuideUtils.getAcceptLang((SlingHttpServletRequest)this.request);
        }
        return FormContainer.super.getLang();
    }

    @Override
    public String getContainingPageLang() {
        if (this.request != null) {
            Page currentPage = this.getCurrentPage();
            if (!GuideWCMUtils.isForms((String)currentPage.getPath())) {
                String pagePath = currentPage.getPath();
                String pageLocaleRoot = LanguageUtil.getLanguageRoot((String)pagePath);
                String locale = "";
                if (StringUtils.isNotBlank((CharSequence)pageLocaleRoot)) {
                    int localeStartIndex = StringUtils.lastIndexOf((CharSequence)pageLocaleRoot, (int)47);
                    locale = StringUtils.substring((String)pageLocaleRoot, (int)(localeStartIndex + 1));
                }
                return locale;
            }
            return FormContainer.super.getContainingPageLang();
        }
        return FormContainer.super.getContainingPageLang();
    }

    @Override
    public String getLanguageDirection() {
        return "ltr";
    }

    @Override
    @NotNull
    public Map<String, Object> getProperties() {
        Map<String, Object> properties = super.getProperties();
        if (this.getSchemaType() != null) {
            properties.put(FD_SCHEMA_TYPE, this.getSchemaType());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getSchemaRef())) {
            properties.put(FD_SCHEMA_REF, this.getSchemaRef());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getPrefillService()) || this.request != null && StringUtils.isNotBlank((CharSequence)this.request.getParameter("dataRef"))) {
            this.formDataEnabled = true;
        }
        properties.put(FD_FORM_DATA_ENABLED, this.formDataEnabled);
        return properties;
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getDorProperties() {
        LinkedHashMap<String, Object> customDorProperties = new LinkedHashMap<String, Object>();
        if (this.dorType != null) {
            customDorProperties.put(DOR_TYPE, this.dorType);
        }
        if (this.dorTemplateRef != null) {
            customDorProperties.put(DOR_TEMPLATE_REF, this.dorTemplateRef);
        }
        if (this.dorTemplateType != null) {
            customDorProperties.put(DOR_TEMPLATE_TYPE, this.dorTemplateType);
        }
        return customDorProperties;
    }

    @Override
    @JsonIgnore
    public void visit(Consumer<ComponentExporter> callback) throws Exception {
        this.traverseChild(this, callback);
    }

    private void traverseChild(Container container, Consumer<ComponentExporter> callback) throws Exception {
        for (ComponentExporter componentExporter : container.getItems()) {
            callback.accept(componentExporter);
            if (!(componentExporter instanceof Container)) continue;
            this.traverseChild((Container)componentExporter, callback);
        }
    }

    @Override
    @JsonIgnore
    public String getParentPagePath() {
        PageManager pm;
        if (this.resource != null && (pm = (PageManager)this.resource.getResourceResolver().adaptTo(PageManager.class)) != null) {
            Page page = pm.getContainingPage(this.resource);
            return page != null ? page.getPath() : "";
        }
        return "";
    }

    @Override
    public String getName() {
        return FormContainer.super.getName();
    }
}

