/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.internal.models.v1.form;

import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.forms.core.components.internal.Heading;
import com.adobe.cq.forms.core.components.util.AbstractComponentImpl;
import com.adobe.cq.forms.core.components.util.ComponentUtils;
import com.adobe.cq.wcm.core.components.models.Title;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ComponentDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={Title.class, ComponentExporter.class}, resourceType={"core/fd/components/form/title/v1/title"})
@Exporter(name="jackson", extensions={"json"})
public class TitleImpl
extends AbstractComponentImpl
implements Title {
    @SlingObject
    private Resource resource;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @JsonIgnore
    @Nullable
    private Style currentStyle;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String type;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="jcr:title")
    @Nullable
    private String title;
    private Heading heading;

    @PostConstruct
    private void initModel() {
        Resource formContainerResource;
        if (this.request != null && this.i18n == null) {
            this.i18n = GuideUtils.getI18n((SlingHttpServletRequest)this.request, (Resource)this.resource);
        }
        if (StringUtils.isBlank((CharSequence)this.title) && (formContainerResource = ComponentUtils.getFormContainer(this.resource)) != null) {
            this.title = (String)formContainerResource.getValueMap().get("title", String.class);
        }
        if (this.heading == null) {
            this.heading = Heading.getHeading(this.type);
            if (this.heading == null && this.currentStyle != null) {
                this.heading = Heading.getHeading((String)this.currentStyle.get("type", String.class));
            }
        }
    }

    public String getText() {
        String propertyName = "jcr:title";
        String propertyValue = this.title;
        boolean editMode = true;
        if (this.request != null) {
            boolean bl = editMode = WCMMode.fromRequest((ServletRequest)this.request) == WCMMode.EDIT || WCMMode.fromRequest((ServletRequest)this.request) == WCMMode.DESIGN;
        }
        if (editMode) {
            return propertyValue;
        }
        if (StringUtils.isBlank((CharSequence)propertyValue)) {
            return null;
        }
        return ComponentUtils.translate(propertyValue, propertyName, this.resource, this.i18n);
    }

    public String getType() {
        if (this.heading != null) {
            return this.heading.getElement();
        }
        return null;
    }

    @Override
    @NotNull
    protected ComponentData getComponentData() {
        return ((ComponentDataBuilder)DataLayerBuilder.extending((ComponentData)super.getComponentData()).asComponent().withTitle(this::getText)).build();
    }
}

