/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.internal.datalayer;

import com.adobe.cq.forms.core.components.datalayer.FormComponentData;
import com.adobe.cq.forms.core.components.internal.models.v2.form.FormContainerImpl;
import com.adobe.cq.forms.core.components.models.form.FormComponent;
import com.adobe.cq.forms.core.components.models.form.Label;
import com.adobe.cq.forms.core.components.util.AbstractFormComponentImpl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Calendar;
import java.util.Date;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentDataImpl
implements FormComponentData {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentDataImpl.class);
    protected final FormComponent component;
    protected final Resource resource;

    public ComponentDataImpl(FormComponent component, Resource resource) {
        this.component = component;
        this.resource = resource;
    }

    private AbstractFormComponentImpl getComponentAsFormComponent() {
        if (this.component instanceof AbstractFormComponentImpl) {
            return (AbstractFormComponentImpl)this.component;
        }
        return null;
    }

    public String getId() {
        return this.component.getId();
    }

    public String getType() {
        return this.resource.getResourceType();
    }

    public Date getLastModifiedDate() {
        ValueMap valueMap = (ValueMap)this.resource.adaptTo(ValueMap.class);
        Calendar lastModified = null;
        if (valueMap != null && (lastModified = (Calendar)valueMap.get("jcr:lastModified", Calendar.class)) == null) {
            lastModified = (Calendar)valueMap.get("jcr:created", Calendar.class);
        }
        if (lastModified != null) {
            return lastModified.getTime();
        }
        return null;
    }

    public String getText() {
        AbstractFormComponentImpl formComponent = this.getComponentAsFormComponent();
        if (formComponent != null) {
            return formComponent.getText();
        }
        return null;
    }

    public String getLinkUrl() {
        AbstractFormComponentImpl formComponent = this.getComponentAsFormComponent();
        if (formComponent != null) {
            return formComponent.getLinkUrl();
        }
        return null;
    }

    public String getTitle() {
        Label label;
        if (this.component instanceof FormContainerImpl) {
            return ((FormContainerImpl)this.component).getTitle();
        }
        AbstractFormComponentImpl formComponent = this.getComponentAsFormComponent();
        if (formComponent != null && (label = formComponent.getLabel()) != null) {
            return label.getValue();
        }
        return null;
    }

    public String getDescription() {
        AbstractFormComponentImpl formComponent = this.getComponentAsFormComponent();
        if (formComponent != null) {
            return formComponent.getDescription();
        }
        return null;
    }

    public String getParentId() {
        return null;
    }

    @Override
    public String getFieldType() {
        AbstractFormComponentImpl formComponent = this.getComponentAsFormComponent();
        if (formComponent != null) {
            return formComponent.getFieldType();
        }
        return null;
    }

    @Nullable
    public final String getJson() {
        try {
            return String.format("{\"%s\":%s}", this.getId(), new ObjectMapper().writeValueAsString((Object)this));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Unable to generate dataLayer JSON string", (Throwable)e);
            return null;
        }
    }
}

