/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets.embed;

import com.adobe.cq.wcm.core.components.internal.servlets.embed.EmbeddablesDataSourceServlet;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/wcm/components/embed/v1/datasources/embeddesigntabs", "sling.servlet.resourceTypes=core/wcm/components/embed/v2/datasources/embeddesigntabs", "sling.servlet.methods=GET", "sling.servlet.extensions=html"})
public class EmbedDesignTabsDataSourceServlet
extends SlingSafeMethodsServlet {
    public static final String RESOURCE_TYPE_V1 = "core/wcm/components/embed/v1/datasources/embeddesigntabs";
    public static final String RESOURCE_TYPE_V2 = "core/wcm/components/embed/v2/datasources/embeddesigntabs";
    private static final long serialVersionUID = 7672484310019288602L;
    private static final String NN_DESIGN_DIALOG = "cq:design_dialog";

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        SimpleDataSource embeddableOptionsDataSource = new SimpleDataSource(this.getEmbedDesignTabs(request).iterator());
        request.setAttribute(DataSource.class.getName(), (Object)embeddableOptionsDataSource);
    }

    private List<Resource> getEmbedDesignTabs(@NotNull SlingHttpServletRequest request) {
        ArrayList<Resource> embedDesignTabs = new ArrayList<Resource>();
        Resource firstTabs = request.getResource().getChild("firsttabs");
        if (firstTabs != null) {
            firstTabs.getChildren().forEach(embedDesignTabs::add);
        }
        ResourceResolver resolver = request.getResourceResolver();
        for (EmbeddablesDataSourceServlet.EmbeddableDescription embeddableDescription : EmbeddablesDataSourceServlet.findEmbeddables(request.getResourceResolver())) {
            Resource embeddableDesignTab = resolver.getResource(embeddableDescription.getResourceType() + "/" + NN_DESIGN_DIALOG);
            if (embeddableDesignTab == null) continue;
            embedDesignTabs.add(embeddableDesignTab);
        }
        Resource lastTabs = request.getResource().getChild("lasttabs");
        if (lastTabs != null) {
            lastTabs.getChildren().forEach(embedDesignTabs::add);
        }
        return embedDesignTabs;
    }
}

