/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/wcm/components/commons/datasources/allowedcolorswatches/v1", "sling.servlet.methods=GET", "sling.servlet.extensions=html"})
public class AllowedColorSwatchesDataSourceServlet
extends SlingSafeMethodsServlet {
    protected static final String RESOURCE_TYPE = "core/wcm/components/commons/datasources/allowedcolorswatches/v1";
    protected static final String PN_ALLOWED_COLOR_SWATCHES = "allowedColorSwatches";
    protected static final String PN_COLOR_VALUE = "value";

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        SimpleDataSource allowedColorSwatchesDataSource = new SimpleDataSource(this.getAllowedColorSwatches(request).iterator());
        request.setAttribute(DataSource.class.getName(), (Object)allowedColorSwatchesDataSource);
    }

    protected List<Resource> getAllowedColorSwatches(@NotNull SlingHttpServletRequest request) {
        List<Resource> colors = Collections.emptyList();
        String contentPath = (String)request.getAttribute("granite.ui.form.contentpath");
        ResourceResolver resolver = request.getResourceResolver();
        ContentPolicy policy = null;
        if (StringUtils.isNotEmpty((CharSequence)contentPath)) {
            policy = this.getContentPolicy(contentPath, resolver);
        }
        if ((StringUtils.isEmpty((CharSequence)contentPath) || policy == null) && StringUtils.isNotEmpty((CharSequence)(contentPath = request.getRequestPathInfo().getSuffix()))) {
            policy = this.getContentPolicy(contentPath, resolver);
        }
        if (policy != null) {
            colors = this.populateColors(policy, resolver);
        }
        return colors;
    }

    private ContentPolicy getContentPolicy(@NotNull String path, @NotNull ResourceResolver resolver) {
        ContentPolicy policy = null;
        ContentPolicyManager policyMgr = (ContentPolicyManager)resolver.adaptTo(ContentPolicyManager.class);
        Resource contentResource = resolver.getResource(path);
        if (contentResource != null && policyMgr != null) {
            policy = policyMgr.getPolicy(contentResource);
        }
        return policy;
    }

    private List<Resource> populateColors(@NotNull ContentPolicy policy, @NotNull ResourceResolver resolver) {
        String[] allowedColorSwatches;
        ArrayList<Resource> colors = new ArrayList<Resource>();
        ValueMapDecorator color = null;
        ValueMap properties = policy.getProperties();
        if (properties != null && (allowedColorSwatches = (String[])properties.get(PN_ALLOWED_COLOR_SWATCHES, String[].class)) != null && allowedColorSwatches.length > 0) {
            for (String allowedColorSwatch : allowedColorSwatches) {
                color = new ValueMapDecorator(new HashMap());
                color.put((Object)PN_COLOR_VALUE, (Object)allowedColorSwatch);
                colors.add((Resource)new ValueMapResource(resolver, new ResourceMetadata(), "nt:unstructured", (ValueMap)color));
            }
        }
        return colors;
    }
}

