/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.cq.wcm.core.components.internal.servlets.AdaptiveImageServlet;
import com.adobe.cq.wcm.core.components.internal.servlets.AdaptiveImageServletMappingConfigurationFactory;
import com.adobe.cq.wcm.core.components.internal.servlets.AdaptiveImageServletMetrics;
import com.day.cq.dam.api.handler.store.AssetStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AdaptiveImageServletMappingConfigurationConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(AdaptiveImageServletMappingConfigurationConsumer.class);
    @Reference
    private MimeTypeService mimeTypeService;
    @Reference
    private AssetStore assetStore;
    private BundleContext bundleContext;
    private Map<String, AdaptiveImageServletMappingConfigurationFactory> configs = new HashMap<String, AdaptiveImageServletMappingConfigurationFactory>();
    private List<ServiceRegistration> serviceRegistrations = new ArrayList<ServiceRegistration>();
    private int oldAISDefaultResizeWidth = Integer.MIN_VALUE;
    @Reference
    private ConfigurationAdmin configurationAdmin;
    @Reference
    AdaptiveImageServletMetrics metrics;

    @Activate
    public void activate(ComponentContext componentContext, BundleContext bundleContext, Map<String, Object> config) {
        try {
            Object[] configurations = this.configurationAdmin.listConfigurations("(service.pid=" + AdaptiveImageServlet.class.getName() + ")");
            if (ArrayUtils.isNotEmpty((Object[])configurations)) {
                Object oldConfig = configurations[0];
                this.oldAISDefaultResizeWidth = PropertiesUtil.toInteger(oldConfig.getProperties().get("defaultResizeWidth"), (int)Integer.MIN_VALUE);
                if (this.oldAISDefaultResizeWidth > 0) {
                    LOG.warn("Found previous custom configuration for the {}. The configuration will be reused to control the {} registrations managed by this component. Please migrate the previous configuration to the {} factory configurations.", new Object[]{AdaptiveImageServlet.class.getName(), AdaptiveImageServlet.class.getName(), AdaptiveImageServletMappingConfigurationFactory.class.getName()});
                }
            }
        }
        catch (IOException | RuntimeException | InvalidSyntaxException e) {
            LOG.error("Unable to retrieve previous configuration for the " + AdaptiveImageServlet.class.getName() + " component. The configuration, if it still exists, will not be reused to configure the defaultResizeWidth property of the servlet's registrations managed by this component.", e);
        }
        this.bundleContext = bundleContext;
        this.updateServletRegistrations();
    }

    @Deactivate
    public void deactivate() {
        this.configs.clear();
        this.updateServletRegistrations();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, updated="bindAdaptiveImageServletConfigurationFactory")
    protected void bindAdaptiveImageServletConfigurationFactory(AdaptiveImageServletMappingConfigurationFactory configurationFactory, Map<String, ?> properties) {
        String servicePid = (String)properties.get("service.pid");
        this.applyValidConfiguration(configurationFactory, () -> {
            this.configs.put(servicePid, configurationFactory);
            this.updateServletRegistrations();
        });
    }

    protected void unbindAdaptiveImageServletConfigurationFactory(AdaptiveImageServletMappingConfigurationFactory configurationFactory, Map<String, ?> properties) {
        String servicePid = (String)properties.get("service.pid");
        this.configs.remove(servicePid);
        this.updateServletRegistrations();
    }

    private void updateServletRegistrations() {
        for (ServiceRegistration serviceRegistration : this.serviceRegistrations) {
            if (serviceRegistration == null) continue;
            serviceRegistration.unregister();
        }
        this.serviceRegistrations.clear();
        if (this.bundleContext != null) {
            for (AdaptiveImageServletMappingConfigurationFactory config : this.configs.values()) {
                Hashtable<String, Object> properties = new Hashtable<String, Object>();
                properties.put("sling.servlet.methods", new String[]{"GET"});
                properties.put("sling.servlet.resourceTypes", config.getResourceTypes());
                properties.put("sling.servlet.selectors", config.getSelectors());
                properties.put("sling.servlet.extensions", config.getExtensions());
                this.serviceRegistrations.add(this.bundleContext.registerService(Servlet.class.getName(), (Object)new AdaptiveImageServlet(this.mimeTypeService, this.assetStore, this.metrics, this.oldAISDefaultResizeWidth > 0 ? this.oldAISDefaultResizeWidth : config.getDefaultResizeWidth(), config.getMaxSize()), properties));
            }
        }
    }

    private void applyValidConfiguration(AdaptiveImageServletMappingConfigurationFactory config, Runnable apply) {
        if (!(config.getResourceTypes().isEmpty() || config.getSelectors().isEmpty() || config.getExtensions().isEmpty())) {
            apply.run();
        } else {
            LOG.warn("One of the servlet registration properties from the following {} configuration is empty: {}.", (Object)config.getClass().getName(), (Object)config.toString());
        }
    }
}

