/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingPostProcessor.class, Servlet.class}, property={"service.ranking:Integer=2147483647", "sling.servlet.methods=POST", "sling.servlet.resourceTypes=core/wcm/components/panelcontainer/v1/panelcontainer", "sling.servlet.selectors=container", "sling.servlet.extensions=html"})
public class ContainerPostProcessor
extends SlingAllMethodsServlet
implements SlingPostProcessor {
    protected static final String SELECTOR = "container";
    protected static final String EXTENSION = "html";
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerPostProcessor.class);
    private static final String PARAM_ORDERED_CHILDREN = "itemOrder";
    private static final String PARAM_DELETED_CHILDREN = "deletedItems";

    public void process(SlingHttpServletRequest request, List<Modification> modifications) throws Exception {
        ResourceResolver resourceResolver = request.getResource().getResourceResolver();
        ArrayList<Modification> addedModifications = new ArrayList<Modification>();
        if (this.accepts(request, resourceResolver)) {
            Resource container = request.getResource();
            try {
                this.handleOrder(container, request);
                this.handleDelete(container, request, resourceResolver, addedModifications);
            }
            catch (RepositoryException e) {
                LOGGER.error("Could not order items of the container at {}", (Object)container.getPath(), (Object)e);
            }
        }
        modifications.addAll(addedModifications);
    }

    protected void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        ResourceResolver resolver = request.getResourceResolver();
        Resource container = request.getResource();
        try {
            this.handleOrder(container, request);
            resolver.commit();
        }
        catch (RepositoryException | PersistenceException e) {
            LOGGER.error("Could not order items of the container at {}", (Object)container.getPath(), (Object)e);
            response.sendError(500);
        }
    }

    protected void handleOrder(Resource container, SlingHttpServletRequest request) throws RepositoryException {
        Node containerNode;
        String[] orderedChildrenNames = StringUtils.split((String)request.getParameter(PARAM_ORDERED_CHILDREN), (String)",");
        if (orderedChildrenNames != null && orderedChildrenNames.length > 0 && (containerNode = (Node)container.adaptTo(Node.class)) != null) {
            for (int i = orderedChildrenNames.length - 1; i >= 0; --i) {
                if (!containerNode.hasNode(orderedChildrenNames[i])) continue;
                if (i == orderedChildrenNames.length - 1) {
                    containerNode.orderBefore(orderedChildrenNames[i], null);
                    continue;
                }
                if (!containerNode.hasNode(orderedChildrenNames[i + 1])) continue;
                containerNode.orderBefore(orderedChildrenNames[i], orderedChildrenNames[i + 1]);
            }
        }
    }

    protected void handleDelete(Resource container, SlingHttpServletRequest request, ResourceResolver resolver, List<Modification> addedModifications) throws PersistenceException, RepositoryException {
        String[] deletedChildrenNames = StringUtils.split((String)request.getParameter(PARAM_DELETED_CHILDREN), (String)",");
        if (deletedChildrenNames != null && deletedChildrenNames.length > 0) {
            for (String childName : deletedChildrenNames) {
                Resource child = container.getChild(childName);
                if (child == null) continue;
                String deletedPath = child.getPath();
                resolver.delete(child);
                addedModifications.add(Modification.onDeleted((String)deletedPath));
            }
        }
    }

    private boolean accepts(SlingHttpServletRequest request, ResourceResolver resolver) {
        return resolver.isResourceType(request.getResource(), "core/wcm/components/panelcontainer/v1/panelcontainer");
    }
}

