/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.services;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.reference.Reference;
import com.day.cq.wcm.api.reference.ReferenceProvider;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Designate(ocd=Config.class)
@Component(service={ReferenceProvider.class})
public class CaConfigReferenceProvider
implements ReferenceProvider {
    private static final String CA_CONFIG_REFERENCE_TYPE = "caconfig";
    @org.osgi.service.component.annotations.Reference
    private ConfigurationManager configurationManager;
    @org.osgi.service.component.annotations.Reference
    private ConfigurationResourceResolver configurationResourceResolver;
    private boolean enabled;

    @Activate
    protected void activate(Config config) {
        this.enabled = config.enabled();
    }

    @Deactivate
    protected void deactivate() {
        this.enabled = false;
    }

    public List<Reference> findReferences(Resource resource) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        ArrayList<Reference> references = new ArrayList<Reference>();
        PageManager pageManager = (PageManager)resource.getResourceResolver().adaptTo(PageManager.class);
        if (pageManager == null) {
            return references;
        }
        Page page = pageManager.getContainingPage(resource);
        if (page == null) {
            return references;
        }
        for (String config : this.configurationManager.getConfigurationNames()) {
            this.addCaConfigReference(config, resource, references);
        }
        return references;
    }

    private void addCaConfigReference(String configName, Resource resource, List<Reference> references) {
        Resource configResource = this.configurationResourceResolver.getResource(resource, "sling:configs", configName);
        if (configResource != null) {
            references.add(new Reference(CA_CONFIG_REFERENCE_TYPE, configName, configResource, this.getLastModificationTime(configResource)));
        }
    }

    private long getLastModificationTime(Resource configResource) {
        Page configPage = (Page)configResource.adaptTo(Page.class);
        if (configPage != null) {
            Calendar lastModified = configPage.getLastModified();
            return lastModified != null ? lastModified.getTimeInMillis() : -1L;
        }
        return configResource.getResourceMetadata().getModificationTime();
    }

    @ObjectClassDefinition(name="Core Components Context-Aware Configuration Reference Provider")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable this reference provider")
        public boolean enabled() default true;
    }
}

