/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v4;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.commons.link.LinkManager;
import com.adobe.cq.wcm.core.components.internal.link.LinkManagerImpl;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractListItemImpl;
import com.adobe.cq.wcm.core.components.internal.models.v1.ListImpl;
import com.adobe.cq.wcm.core.components.internal.models.v4.ExternalLinkListItemImpl;
import com.adobe.cq.wcm.core.components.internal.models.v4.PageListItemImpl;
import com.adobe.cq.wcm.core.components.models.List;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.jetbrains.annotations.NotNull;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={List.class, ComponentExporter.class}, resourceType={"core/wcm/components/list/v4/list"})
@Exporter(name="jackson", extensions={"json"})
public class ListImpl
extends com.adobe.cq.wcm.core.components.internal.models.v3.ListImpl
implements List {
    protected static final String RESOURCE_TYPE = "core/wcm/components/list/v4/list";

    @Override
    protected ListItem newPageListItem(@NotNull LinkManager linkManager, @NotNull Page page, String parentId, Component component) {
        Resource listResource = this.getListResource();
        return new PageListItemImpl(linkManager.get(page).build(), page, parentId, component, this.showDescription, this.linkItems || this.displayItemAsTeaser, listResource);
    }

    @Override
    @JsonProperty(value="items")
    @NotNull
    public Collection<ListItem> getListItems() {
        Resource staticNode;
        if (this.listItems == null && ListImpl.Source.STATIC.equals((Object)this.getListType()) && (staticNode = this.resource.getChild("static")) != null) {
            this.listItems = this.getStaticListItems();
        }
        return super.getListItems();
    }

    private Collection<ListItem> getStaticListItems() {
        int direction;
        Stream<AbstractListItemImpl> itemStream = this.getStaticItemResourceStream().map(linkResource -> {
            Link link = this.linkManager.get((Resource)linkResource).build();
            if (LinkManagerImpl.isExternalLink(link.getURL())) {
                return new ExternalLinkListItemImpl(link, (Resource)linkResource, this.getId(), this.component);
            }
            Object reference = link.getReference();
            if (reference instanceof Page) {
                return new PageListItemImpl(link, (Page)reference, (Resource)linkResource, this.getId(), this.component, this.showDescription, this.linkItems || this.displayItemAsTeaser, this.resource);
            }
            return null;
        }).filter(Objects::nonNull).filter(item -> item.getLink() != null && item.getLink().isValid());
        ListImpl.OrderBy orderBy = ListImpl.OrderBy.fromString((String)this.properties.get("orderBy", (Object)""));
        ListImpl.SortOrder sortOrder = ListImpl.SortOrder.fromString((String)this.properties.get("sortOrder", (Object)ListImpl.SortOrder.ASC.value));
        int n = direction = sortOrder.equals((Object)ListImpl.SortOrder.ASC) ? 1 : -1;
        if (ListImpl.OrderBy.TITLE.equals((Object)orderBy)) {
            Collator collator = Collator.getInstance(this.currentPage.getLanguage());
            collator.setStrength(0);
            Comparator<Object> titleComparator = Comparator.nullsLast(collator);
            itemStream = itemStream.sorted((item1, item2) -> direction * titleComparator.compare(item1.getTitle(), item2.getTitle()));
        } else if (ListImpl.OrderBy.MODIFIED.equals((Object)orderBy)) {
            itemStream = itemStream.sorted((item1, item2) -> direction * ObjectUtils.compare((Comparable)item1.getLastModified(), (Comparable)item2.getLastModified(), (boolean)true));
        }
        return itemStream.collect(Collectors.toList());
    }

    private Stream<Resource> getStaticItemResourceStream() {
        Resource staticNode = this.resource.getChild("static");
        if (staticNode == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(staticNode.getChildren().spliterator(), false);
    }
}

