/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v4;

import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractListItemImpl;
import com.adobe.cq.wcm.core.components.internal.resource.CoreResourceWrapper;
import com.day.cq.wcm.api.components.Component;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalLinkListItemImpl
extends AbstractListItemImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalLinkListItemImpl.class);
    private final Link link;
    private String linkText;
    private Resource teaserResource;

    ExternalLinkListItemImpl(@NotNull Link link, Resource resource, String parentId, Component component) {
        super(parentId, resource, component);
        this.component = component;
        ValueMap properties = resource.getValueMap();
        this.linkText = (String)properties.get("linkText", String.class);
        this.link = link;
        if (StringUtils.isBlank((CharSequence)this.linkText)) {
            this.linkText = this.link.getURL();
        }
    }

    @Override
    @Nullable
    public Link getLink() {
        return this.link;
    }

    @Override
    @Nullable
    public String getURL() {
        return this.link.getURL();
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.linkText;
    }

    @Override
    @JsonIgnore
    public Resource getTeaserResource() {
        if (this.teaserResource == null && this.component != null) {
            String delegateResourceType = (String)this.component.getProperties().get("teaserDelegate", String.class);
            if (StringUtils.isEmpty((CharSequence)delegateResourceType)) {
                LOGGER.error("In order for list rendering delegation to work correctly you need to set up the teaserDelegate property on the {} component; its value has to point to the resource type of a teaser component.", (Object)this.component.getPath());
            } else {
                HashMap<String, Object> overriddenProperties = new HashMap<String, Object>();
                String target = this.link.getHtmlAttributes().get("target");
                if (StringUtils.isNotBlank((CharSequence)target)) {
                    overriddenProperties.put("linkTarget", target);
                }
                overriddenProperties.put("jcr:title", this.linkText);
                overriddenProperties.put("titleFromPage", false);
                this.teaserResource = new CoreResourceWrapper(this.resource, delegateResourceType, null, overriddenProperties);
            }
        }
        return this.teaserResource;
    }
}

