/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1.form;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.models.v1.form.AbstractFieldImpl;
import com.adobe.cq.wcm.core.components.models.form.Text;
import com.day.cq.wcm.foundation.forms.FormStructureHelperFactory;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Text.class, ComponentExporter.class}, resourceType={"core/wcm/components/form/text/v1/text", "core/wcm/components/form/text/v2/text"})
@Exporter(name="jackson", extensions={"json"})
public class TextImpl
extends AbstractFieldImpl
implements Text,
ComponentExporter {
    private static final String ID_PREFIX = "form-text";
    private static final String PROP_NAME_DEFAULT = "text";
    private static final String PROP_VALUE_DEFAULT = "";
    private static final String PROP_TITLE_DEFAULT = "Text input field";
    private static final boolean PROP_READONLY_DEFAULT = false;
    private static final boolean PROP_REQUIRED_DEFAULT = false;
    private static final String PROP_REQUIRED_MESSAGE_DEFAULT = "";
    private static final String PROP_CONSTRAINT_MESSAGE_DEFAULT = "";
    private static final String PROP_TYPE_DEFAULT = "text";
    private static final String PROP_HELP_MESSAGE_DEFAULT = "";
    private static final boolean PROP_USE_PLACEHOLDER_DEFAULT = false;
    private static final int PROP_ROWS_DEFAULT = 2;
    private static final boolean PROP_HIDE_TITLE_DEFAULT = false;
    @Self
    private SlingHttpServletRequest slingRequest;
    @ScriptVariable
    private Resource resource;
    @Inject
    private FormStructureHelperFactory formStructureHelperFactory;
    private String[] prefillValues;
    @ValueMapValue
    @Default(values={""})
    private String helpMessage;
    private String placeholder;
    @ValueMapValue
    @Default(booleanValues={false})
    private boolean usePlaceholder;
    @ValueMapValue
    @Default(values={"text"})
    private String type;
    @ValueMapValue
    @Default(booleanValues={false})
    private boolean readOnly;
    @ValueMapValue
    @Default(booleanValues={false})
    private boolean required;
    @ValueMapValue
    @Default(values={""})
    private String requiredMessage;
    @ValueMapValue
    @Default(values={""})
    private String constraintMessage;
    @ValueMapValue
    @Default(intValues={2})
    private int rows;
    @ValueMapValue
    @Default(booleanValues={false})
    private boolean hideTitle;

    @PostConstruct
    private void initModel() {
        this.slingRequest.setAttribute("cq.form.formstructurehelper", (Object)this.formStructureHelperFactory.getFormStructureHelper(this.resource));
        this.prefillValues = FormsHelper.getValues((SlingHttpServletRequest)this.slingRequest, (Resource)this.resource);
        if (this.prefillValues == null) {
            this.prefillValues = new String[]{this.getDefaultValue()};
        }
        if (this.usePlaceholder) {
            this.placeholder = this.helpMessage;
        }
    }

    @Override
    public String getValue() {
        String value = super.getValue();
        if (value.equals("") && this.prefillValues.length > 0) {
            value = this.prefillValues[0];
        }
        return value;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public String getDefaultValue() {
        return "";
    }

    @Override
    public String getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public String getRequiredMessage() {
        return this.requiredMessage;
    }

    @Override
    public String getConstraintMessage() {
        return this.constraintMessage;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public String getHelpMessage() {
        return this.helpMessage;
    }

    @Override
    protected String getIDPrefix() {
        return ID_PREFIX;
    }

    @Override
    protected String getDefaultName() {
        return "text";
    }

    @Override
    protected String getDefaultTitle() {
        return PROP_TITLE_DEFAULT;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean hideTitle() {
        return this.hideTitle;
    }
}

