/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1.form;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.export.json.SlingModelFilter;
import com.adobe.cq.wcm.core.components.commons.link.LinkManager;
import com.adobe.cq.wcm.core.components.models.form.Container;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.foundation.forms.FormStructureHelper;
import com.day.cq.wcm.foundation.forms.FormStructureHelperFactory;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.cq.wcm.foundation.forms.ValidationInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Container.class, ContainerExporter.class, ComponentExporter.class}, resourceType={"core/wcm/components/form/container/v1/container", "core/wcm/components/form/container/v2/container"})
@Exporter(name="jackson", extensions={"json"})
public class ContainerImpl
implements Container {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerImpl.class);
    private static final String PROP_METHOD_DEFAULT = "POST";
    private static final String PROP_ENCTYPE_DEFAULT = "multipart/form-data";
    private static final String INIT_SCRIPT = "init";
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable
    private SlingHttpServletResponse response;
    @ScriptVariable
    private Page currentPage;
    @ValueMapValue
    @Default(values={"POST"})
    private String method;
    @ValueMapValue
    @Default(values={"multipart/form-data"})
    private String enctype;
    @ValueMapValue
    @Default(values={""})
    private String id;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String actionType;
    @ValueMapValue(name="sling:resourceType")
    @Default(values={""})
    private String dropAreaResourceType;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String redirect;
    @Self
    private LinkManager linkManager;
    private String name;
    private String action;
    private Map<String, ? extends ComponentExporter> childrenModels;
    private String[] exportedItemsOrder;
    private String[] errorMessages;
    @ScriptVariable
    private Resource resource;
    @OSGiService
    private FormStructureHelperFactory formStructureHelperFactory;
    @OSGiService
    private SlingModelFilter slingModelFilter;
    @OSGiService
    private ModelFactory modelFactory;

    @PostConstruct
    private void initModel() {
        ValidationInfo info;
        String contextPath;
        FormStructureHelper formStructureHelper = this.formStructureHelperFactory.getFormStructureHelper(this.resource);
        this.request.setAttribute("cq.form.formstructurehelper", (Object)formStructureHelper);
        this.action = this.linkManager.get(this.currentPage).build().getURL();
        String formId = FormsHelper.getFormId((SlingHttpServletRequest)this.request);
        if (StringUtils.isBlank((CharSequence)this.id)) {
            this.id = formId;
        }
        this.request.setAttribute("cq.form.id", (Object)this.getId());
        this.name = this.id;
        this.dropAreaResourceType = "wcm/foundation/components/responsivegrid/new";
        if (this.redirect != null && StringUtils.isNotBlank((CharSequence)(contextPath = this.request.getContextPath())) && this.redirect.startsWith("/")) {
            this.redirect = contextPath + this.redirect;
        }
        if (!StringUtils.equals((CharSequence)this.request.getRequestPathInfo().getExtension(), (CharSequence)"json")) {
            this.runActionTypeInit(formStructureHelper);
        }
        if ((info = ValidationInfo.getValidationInfo((HttpServletRequest)this.request)) != null) {
            this.errorMessages = info.getErrorMessages(null);
        }
    }

    private void runActionTypeInit(FormStructureHelper formStructureHelper) {
        if (this.request.getAttribute("cq.form.init") == null) {
            this.request.setAttribute("cq.form.init", (Object)"true");
            RequestPathInfo requestPathInfo = this.request.getRequestPathInfo();
            if (this.response != null && !StringUtils.equals((CharSequence)requestPathInfo.getSelectorString(), (CharSequence)"formservervalidation") && StringUtils.isNotEmpty((CharSequence)this.actionType)) {
                Resource formStart = formStructureHelper.getFormResource(this.request.getResource());
                try {
                    FormsHelper.runAction((String)this.actionType, (String)INIT_SCRIPT, (Resource)formStart, (SlingHttpServletRequest)this.request, (SlingHttpServletResponse)this.response);
                }
                catch (IOException | ServletException e) {
                    LOGGER.error("Unable to initialise form " + this.resource.getPath(), e);
                }
            }
            this.request.removeAttribute("cq.form.init");
        }
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEnctype() {
        return this.enctype;
    }

    @Override
    public String getResourceTypeForDropArea() {
        return this.dropAreaResourceType;
    }

    @Override
    public String getRedirect() {
        return this.redirect;
    }

    @Override
    @Nullable
    public String[] getErrorMessages() {
        if (this.errorMessages != null && this.errorMessages.length > 0) {
            return Arrays.copyOf(this.errorMessages, this.errorMessages.length);
        }
        return new String[0];
    }

    @Override
    @NotNull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        if (this.childrenModels == null) {
            this.childrenModels = this.getChildrenModels(this.request, ComponentExporter.class);
        }
        return this.childrenModels;
    }

    @Override
    @NotNull
    public String[] getExportedItemsOrder() {
        if (this.exportedItemsOrder == null) {
            Map<String, ? extends ComponentExporter> models = this.getExportedItems();
            this.exportedItemsOrder = !models.isEmpty() ? models.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY) : ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return Arrays.copyOf(this.exportedItemsOrder, this.exportedItemsOrder.length);
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    private <T> Map<String, T> getChildrenModels(@NotNull SlingHttpServletRequest request, @NotNull Class<T> modelClass) {
        LinkedHashMap<String, Object> models = new LinkedHashMap<String, Object>();
        for (Resource child : this.slingModelFilter.filterChildResources(this.resource.getChildren())) {
            Object model = this.modelFactory.getModelFromWrappedRequest(request, child, modelClass);
            if (model == null) continue;
            models.put(child.getName(), model);
        }
        return models;
    }
}

