/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1.datalayer;

import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerSupplier;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentDataImpl
implements ComponentData {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentDataImpl.class);
    @NotNull
    private final DataLayerSupplier dataLayerSupplier;
    private String id;
    private String type;
    private Date lastModifiedDate;
    private String parentId;
    private String title;
    private String description;
    private String text;
    private String linkUrl;

    public ComponentDataImpl(@NotNull DataLayerSupplier supplier) {
        this.dataLayerSupplier = supplier;
    }

    @Override
    @NotNull
    public final String getId() {
        if (this.id == null) {
            this.id = this.getDataLayerSupplier().getId().get();
        }
        return this.id;
    }

    @Override
    @Nullable
    public final String getType() {
        if (this.type == null) {
            this.type = this.getDataLayerSupplier().getType().map(Supplier::get).orElse(null);
        }
        return this.type;
    }

    @Override
    @Nullable
    public final Date getLastModifiedDate() {
        if (this.lastModifiedDate == null) {
            this.lastModifiedDate = this.getDataLayerSupplier().getLastModifiedDate().map(Supplier::get).orElse(null);
        }
        if (this.lastModifiedDate != null) {
            return new Date(this.lastModifiedDate.getTime());
        }
        return null;
    }

    @Override
    @Nullable
    public final String getParentId() {
        if (this.parentId == null) {
            this.parentId = this.getDataLayerSupplier().getParentId().map(Supplier::get).orElse(null);
        }
        return this.parentId;
    }

    @Override
    @Nullable
    public final String getTitle() {
        if (this.title == null) {
            this.title = this.getDataLayerSupplier().getTitle().map(Supplier::get).orElse(null);
        }
        return this.title;
    }

    @Override
    @Nullable
    public final String getDescription() {
        if (this.description == null) {
            this.description = this.getDataLayerSupplier().getDescription().map(Supplier::get).orElse(null);
        }
        return this.description;
    }

    @Override
    @Nullable
    public final String getText() {
        if (this.text == null) {
            this.text = this.getDataLayerSupplier().getText().map(Supplier::get).orElse(null);
        }
        return this.text;
    }

    @Override
    @Nullable
    public final String getLinkUrl() {
        if (this.linkUrl == null) {
            this.linkUrl = this.getDataLayerSupplier().getLinkUrl().map(Supplier::get).orElse(null);
        }
        return this.linkUrl;
    }

    @Override
    @Nullable
    public final String getJson() {
        try {
            return String.format("{\"%s\":%s}", this.getId(), new ObjectMapper().writeValueAsString((Object)this));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Unable to generate dataLayer JSON string", (Throwable)e);
            return null;
        }
    }

    @NotNull
    protected final DataLayerSupplier getDataLayerSupplier() {
        return this.dataLayerSupplier;
    }
}

