/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.commons.link.LinkManager;
import com.adobe.cq.wcm.core.components.internal.Heading;
import com.adobe.cq.wcm.core.components.models.Title;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ComponentDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Title.class, ComponentExporter.class}, resourceType={"core/wcm/components/title/v1/title", "core/wcm/components/title/v2/title"})
@Exporter(name="jackson", extensions={"json"})
public class TitleImpl
extends AbstractComponentImpl
implements Title {
    protected static final String RESOURCE_TYPE_V1 = "core/wcm/components/title/v1/title";
    protected static final String RESOURCE_TYPE_V2 = "core/wcm/components/title/v2/title";
    private boolean linkDisabled = false;
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable
    private Resource resource;
    @ScriptVariable
    private PageManager pageManager;
    @ScriptVariable
    private Page currentPage;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @JsonIgnore
    @Nullable
    private Style currentStyle;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="jcr:title")
    @Nullable
    private String title;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String type;
    @Self
    private LinkManager linkManager;
    protected Link link;
    private Heading heading;

    @PostConstruct
    private void initModel() {
        if (StringUtils.isBlank((CharSequence)this.title)) {
            this.title = (String)StringUtils.defaultIfEmpty((CharSequence)this.currentPage.getPageTitle(), (CharSequence)this.currentPage.getTitle());
        }
        if (this.heading == null) {
            this.heading = Heading.getHeading(this.type);
            if (this.heading == null && this.currentStyle != null) {
                this.heading = Heading.getHeading((String)this.currentStyle.get("type", String.class));
            }
        }
        this.link = this.linkManager.get(this.resource).build();
        if (this.currentStyle != null) {
            this.linkDisabled = (Boolean)this.currentStyle.get("linkDisabled", (Object)this.linkDisabled);
        }
    }

    @Override
    public String getText() {
        return this.title;
    }

    @Override
    public String getType() {
        if (this.heading != null) {
            return this.heading.getElement();
        }
        return null;
    }

    @Override
    @Deprecated
    public String getLinkURL() {
        return this.link.getURL();
    }

    @Override
    public Link getLink() {
        return this.link.isValid() ? this.link : null;
    }

    @Override
    public boolean isLinkDisabled() {
        return this.linkDisabled;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    @Override
    @NotNull
    protected ComponentData getComponentData() {
        return ((ComponentDataBuilder)((ComponentDataBuilder)DataLayerBuilder.extending(super.getComponentData()).asComponent().withTitle(this::getText)).withLinkUrl(() -> this.link.getMappedURL())).build();
    }
}

