/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.commons.link.LinkManager;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractListItemImpl;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.datalayer.PageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.PageDataBuilder;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Calendar;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageListItemImpl
extends AbstractListItemImpl
implements ListItem {
    protected Page page;
    protected Link<Page> link;

    public PageListItemImpl(@NotNull LinkManager linkManager, @NotNull Page page, String parentId, Component component) {
        this(linkManager.get(page).build(), page, parentId, component);
    }

    public PageListItemImpl(@NotNull Link link, @NotNull Page page, String parentId, Component component) {
        super(parentId, page.getContentResource(), component);
        this.parentId = parentId;
        this.link = link;
        this.page = this.link.isValid() && link.getReference() instanceof Page ? (Page)link.getReference() : page;
    }

    @Override
    @JsonIgnore
    @Nullable
    public Link<Page> getLink() {
        return this.link;
    }

    @Override
    public String getURL() {
        return this.link.getURL();
    }

    @Override
    public String getTitle() {
        return PageListItemImpl.getTitle(this.page);
    }

    public static String getTitle(@NotNull Page page) {
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> ((Page)page).getNavigationTitle();
        supplierArray[1] = () -> ((Page)page).getPageTitle();
        supplierArray[2] = () -> ((Page)page).getTitle();
        return Stream.of(supplierArray).map(Supplier::get).filter(StringUtils::isNotBlank).findFirst().orElseGet(() -> ((Page)page).getName());
    }

    @Override
    public String getDescription() {
        return this.page.getDescription();
    }

    @Override
    public Calendar getLastModified() {
        return this.page.getLastModified();
    }

    @Override
    public String getPath() {
        return this.page.getPath();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.page.getName();
    }

    @Override
    @NotNull
    protected PageData getComponentData() {
        return ((PageDataBuilder)((PageDataBuilder)DataLayerBuilder.extending(super.getComponentData()).asPage().withTitle(this::getTitle)).withLinkUrl(() -> this.link.getMappedURL())).build();
    }
}

