/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.commons.link.LinkManager;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.helper.image.AssetDeliveryHelper;
import com.adobe.cq.wcm.core.components.models.Image;
import com.adobe.cq.wcm.core.components.models.datalayer.ImageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.AssetDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ImageComponentDataBuilder;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import com.adobe.cq.wcm.spi.AssetDelivery;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Calendar;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Source;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Image.class, ComponentExporter.class}, resourceType={"core/wcm/components/image/v1/image"})
@Exporter(name="jackson", extensions={"json"})
public class ImageImpl
extends AbstractComponentImpl
implements Image {
    public static final String RESOURCE_TYPE = "core/wcm/components/image/v1/image";
    private static final String DEFAULT_EXTENSION = "jpeg";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageImpl.class);
    protected static final String DOT = ".";
    protected static final String MIME_TYPE_IMAGE_JPEG = "image/jpeg";
    protected static final String MIME_TYPE_IMAGE_SVG = "image/svg+xml";
    private static final String MIME_TYPE_IMAGE_PREFIX = "image/";
    protected static final String SEO_NAME_FILTER_PATTERN = "[\\W|_]";
    @ScriptVariable
    protected PageManager pageManager;
    @ScriptVariable
    protected Page currentPage;
    @ScriptVariable
    protected Style currentStyle;
    @Inject
    @Source(value="osgi-services")
    protected MimeTypeService mimeTypeService;
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    protected AssetDelivery assetDelivery;
    @Self
    protected LinkManager linkManager;
    protected ValueMap properties;
    protected String fileReference;
    protected String alt;
    protected String title;
    protected String externalImageResourcePath;
    protected String src;
    protected String[] smartImages = new String[0];
    protected int[] smartSizes = new int[0];
    protected String json;
    protected boolean displayPopupTitle;
    protected boolean isDecorative;
    protected boolean hasContent;
    protected String mimeType;
    protected String selector = "img";
    protected String extension;
    protected long lastModifiedDate = 0L;
    protected boolean inTemplate = false;
    protected boolean hasExternalImageResource = false;
    protected String baseResourcePath;
    protected String templateRelativePath;
    protected boolean disableLazyLoading;
    protected int jpegQuality;
    protected String imageName;
    protected Resource fileResource;
    protected Link link;
    protected boolean useAssetDelivery = false;

    protected void initResource() {
    }

    @PostConstruct
    protected void initModel() {
        this.initResource();
        this.properties = this.resource.getValueMap();
        this.fileResource = this.resource.getChild("file");
        this.fileReference = (String)this.properties.get("fileReference", String.class);
        this.alt = (String)this.properties.get("alt", String.class);
        this.title = (String)this.properties.get("jcr:title", String.class);
        this.externalImageResourcePath = (String)this.properties.get("externalImageResourcePath", String.class);
        if (StringUtils.isNotEmpty((CharSequence)this.externalImageResourcePath)) {
            this.hasExternalImageResource = true;
        }
        this.mimeType = MIME_TYPE_IMAGE_JPEG;
        this.displayPopupTitle = (Boolean)this.properties.get("displayPopupTitle", this.currentStyle.get("displayPopupTitle", (Object)false));
        this.isDecorative = (Boolean)this.properties.get("isDecorative", this.currentStyle.get("isDecorative", (Object)false));
        this.useAssetDelivery = (Boolean)this.currentStyle.get("enableAssetDelivery", (Object)false) != false && this.assetDelivery != null;
        Asset asset = null;
        if (StringUtils.isNotEmpty((CharSequence)this.fileReference)) {
            Resource assetResource = this.request.getResourceResolver().getResource(this.fileReference);
            if (assetResource != null) {
                asset = (Asset)assetResource.adaptTo(Asset.class);
                if (asset != null) {
                    this.mimeType = PropertiesUtil.toString((Object)asset.getMimeType(), (String)MIME_TYPE_IMAGE_JPEG);
                    this.imageName = this.getImageNameFromAsset(asset);
                    this.hasContent = true;
                } else {
                    this.useAssetDelivery = false;
                    LOGGER.error("Unable to adapt resource '{}' used by image '{}' to an asset.", (Object)this.fileReference, (Object)this.resource.getPath());
                }
            } else {
                this.useAssetDelivery = false;
                if (!this.hasContent) {
                    LOGGER.error("Unable to find resource '{}' used by image '{}'.", (Object)this.fileReference, (Object)this.resource.getPath());
                }
            }
        } else {
            this.useAssetDelivery = false;
            if (this.fileResource != null) {
                String fileName;
                Resource fileResourceContent;
                this.mimeType = PropertiesUtil.toString((Object)this.fileResource.getResourceMetadata().get((Object)"sling.contentType"), null);
                if (StringUtils.isEmpty((CharSequence)this.mimeType) && (fileResourceContent = this.fileResource.getChild("jcr:content")) != null) {
                    ValueMap fileProperties = fileResourceContent.getValueMap();
                    this.mimeType = (String)fileProperties.get("jcr:mimeType", (Object)MIME_TYPE_IMAGE_JPEG);
                }
                this.imageName = StringUtils.isNotEmpty((CharSequence)(fileName = (String)this.properties.get("fileName", String.class))) ? this.getSeoFriendlyName(FilenameUtils.getBaseName((String)fileName)) : "";
                this.hasContent = true;
            }
        }
        if (this.hasContent) {
            long assetLastModifiedDate;
            if (!this.mimeType.startsWith(MIME_TYPE_IMAGE_PREFIX)) {
                LOGGER.error("Image at {} uses a binary with a non-image mime type ({})", (Object)this.resource.getPath(), (Object)this.mimeType);
                this.hasContent = false;
                return;
            }
            this.mimeType = this.mimeType.split(";")[0];
            this.extension = this.mimeTypeService.getExtension(this.mimeType);
            Calendar lastModified = (Calendar)this.properties.get("jcr:lastModified", Calendar.class);
            if (lastModified == null) {
                lastModified = (Calendar)this.properties.get("cq:lastModified", Calendar.class);
            }
            if (lastModified != null) {
                this.lastModifiedDate = lastModified.getTimeInMillis();
            }
            if (asset != null && (assetLastModifiedDate = asset.getLastModified()) > this.lastModifiedDate) {
                this.lastModifiedDate = assetLastModifiedDate;
            }
            if (this.extension == null || this.extension.equalsIgnoreCase("tif") || this.extension.equalsIgnoreCase("tiff")) {
                this.extension = DEFAULT_EXTENSION;
            }
            this.disableLazyLoading = (Boolean)this.currentStyle.get("disableLazyLoading", (Object)false);
            this.jpegQuality = (Integer)this.currentStyle.get("jpegQuality", (Object)82);
            int index = 0;
            Template template = this.currentPage.getTemplate();
            if (template != null && this.resource.getPath().startsWith(template.getPath())) {
                this.inTemplate = true;
                this.baseResourcePath = this.currentPage.getPath();
                this.templateRelativePath = this.resource.getPath().substring(template.getPath().length());
            } else {
                this.baseResourcePath = this.resource.getPath();
                if (this.resource.getResourceResolver().getResource(this.resource.getPath()) == null) {
                    this.baseResourcePath = this.currentPage.getPath();
                }
            }
            this.baseResourcePath = this.resource.getResourceResolver().map((HttpServletRequest)this.request, this.baseResourcePath);
            if (this.smartSizesSupported()) {
                Set<Integer> supportedRenditionWidths = this.getSupportedRenditionWidths();
                this.smartImages = new String[supportedRenditionWidths.size()];
                this.smartSizes = new int[supportedRenditionWidths.size()];
                for (Integer width : supportedRenditionWidths) {
                    String smartImage = "";
                    if (this.useAssetDelivery) {
                        smartImage = AssetDeliveryHelper.getSrc(this.assetDelivery, this.resource, this.imageName, this.extension, width, this.jpegQuality);
                    }
                    if (StringUtils.isEmpty((CharSequence)smartImage)) {
                        smartImage = this.baseResourcePath + DOT + this.selector + DOT + this.jpegQuality + DOT + width + DOT + this.extension + (this.inTemplate ? Text.escapePath((String)this.templateRelativePath) : (this.hasExternalImageResource ? this.externalImageResourcePath : "")) + (this.lastModifiedDate > 0L ? "/" + this.lastModifiedDate + (StringUtils.isNotBlank((CharSequence)this.imageName) ? "/" + this.imageName : "") : "") + (this.inTemplate || this.hasExternalImageResource || this.lastModifiedDate > 0L ? DOT + this.extension : "");
                    }
                    this.smartImages[index] = smartImage;
                    this.smartSizes[index] = width;
                    ++index;
                }
            } else {
                this.smartImages = new String[0];
                this.smartSizes = new int[0];
            }
            if (this.useAssetDelivery) {
                this.src = AssetDeliveryHelper.getSrc(this.assetDelivery, this.resource, this.imageName, this.extension, ArrayUtils.isNotEmpty((int[])this.smartSizes) && this.smartSizes.length == 1 ? Integer.valueOf(this.smartSizes[0]) : null, this.jpegQuality);
            }
            if (StringUtils.isEmpty((CharSequence)this.src)) {
                this.src = this.baseResourcePath + DOT + this.selector + DOT;
                this.src = this.smartSizes.length == 1 ? this.src + this.jpegQuality + DOT + this.smartSizes[0] + DOT + this.extension : this.src + this.extension;
                this.src = this.src + (this.inTemplate ? Text.escapePath((String)this.templateRelativePath) : (this.hasExternalImageResource ? this.externalImageResourcePath : ""));
                this.src = this.src + (this.lastModifiedDate > 0L ? "/" + this.lastModifiedDate + (StringUtils.isNotBlank((CharSequence)this.imageName) ? "/" + this.imageName : "") : "");
                this.src = this.src + (this.inTemplate || this.hasExternalImageResource || this.lastModifiedDate > 0L ? DOT + this.extension : "");
            }
            if (!this.isDecorative) {
                this.link = this.linkManager.get(this.resource).build();
            } else {
                this.alt = null;
            }
            this.buildJson();
        }
    }

    protected String getImageNameFromAsset(Asset asset) {
        return Optional.ofNullable(asset).map(Asset::getName).map(StringUtils::trimToNull).map(FilenameUtils::getBaseName).map(this::getSeoFriendlyName).orElse("");
    }

    protected String getSeoFriendlyName(String imageName) {
        return imageName.replaceAll(SEO_NAME_FILTER_PATTERN, "-").toLowerCase();
    }

    @Override
    public String getSrc() {
        return this.src;
    }

    @Override
    public boolean displayPopupTitle() {
        return this.displayPopupTitle;
    }

    @Override
    public String getAlt() {
        return this.alt;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getLink() {
        return this.link == null ? null : this.link.getURL();
    }

    @Override
    @JsonIgnore
    public String getFileReference() {
        return this.fileReference;
    }

    @Override
    @JsonIgnore
    @Deprecated
    public String getJson() {
        return this.json;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    @Override
    @JsonIgnore
    public boolean isDecorative() {
        return this.isDecorative;
    }

    protected void buildJson() {
        JsonArrayBuilder smartSizesJsonBuilder = Json.createArrayBuilder();
        for (int size : this.smartSizes) {
            smartSizesJsonBuilder.add(size);
        }
        JsonArrayBuilder smartImagesJsonBuilder = Json.createArrayBuilder();
        for (String image : this.smartImages) {
            smartImagesJsonBuilder.add(image);
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("smartImages", smartImagesJsonBuilder);
        jsonObjectBuilder.add("smartSizes", smartSizesJsonBuilder);
        jsonObjectBuilder.add("lazyEnabled", !this.disableLazyLoading);
        this.json = jsonObjectBuilder.build().toString();
    }

    private Set<Integer> getSupportedRenditionWidths() {
        String[] supportedWidthsConfig;
        TreeSet<Integer> allowedRenditionWidths = new TreeSet<Integer>();
        for (String width : supportedWidthsConfig = (String[])this.currentStyle.get("allowedRenditionWidths", (Object)new String[0])) {
            try {
                allowedRenditionWidths.add(Integer.parseInt(width));
            }
            catch (NumberFormatException e) {
                LOGGER.error(String.format("Invalid width detected (%s) for content policy configuration.", width), (Throwable)e);
            }
        }
        return allowedRenditionWidths;
    }

    private boolean smartSizesSupported() {
        return !StringUtils.equals((CharSequence)this.mimeType, (CharSequence)MIME_TYPE_IMAGE_SVG);
    }

    @Override
    @JsonIgnore
    @NotNull
    public ImageData getComponentData() {
        return this.getComponentData(this.fileReference);
    }

    protected ImageData getComponentData(String fileReference) {
        return ((ImageComponentDataBuilder)((ImageComponentDataBuilder)DataLayerBuilder.extending(super.getComponentData()).asImageComponent().withTitle(this::getTitle)).withLinkUrl(() -> Utils.getOptionalLink(this.link).map(Link::getMappedURL).orElse(null))).withAssetData(() -> Optional.ofNullable(fileReference).map(reference -> this.request.getResourceResolver().getResource(reference)).map(assetResource -> (Asset)assetResource.adaptTo(Asset.class)).map(DataLayerBuilder::forAsset).map(AssetDataBuilder::build).orElse(null)).build();
    }
}

