/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.models.ComponentFiles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ComponentFiles.class})
public class ComponentFilesImpl
implements ComponentFiles {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentFilesImpl.class);
    public static final String COMPONENTS_SERVICE = "components-service";
    @Inject
    @Named(value="resourceTypes")
    Object resourceTypes;
    @Inject
    @Named(value="filter")
    String filterRegex;
    @Inject
    @Named(value="inherited")
    @Default(booleanValues={true})
    boolean inherited;
    @OSGiService
    ResourceResolverFactory resolverFactory;
    private Set<String> resourceTypeSet;
    private Pattern pattern;
    private List<String> paths;

    @PostConstruct
    public void init() {
        this.resourceTypeSet = Utils.getStrings(this.resourceTypes);
        this.pattern = Pattern.compile(this.filterRegex);
    }

    @Override
    public List<String> getPaths() {
        if (this.paths == null) {
            this.paths = new LinkedList<String>();
            try (ResourceResolver resourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", COMPONENTS_SERVICE));){
                HashSet<String> seenResourceTypes = new HashSet<String>();
                for (String resourceType : this.resourceTypeSet) {
                    this.addPaths(resourceType, this.paths, seenResourceTypes, resourceResolver);
                }
            }
            catch (LoginException e) {
                LOG.error("Cannot login as a service user", (Throwable)e);
            }
        }
        return this.paths;
    }

    private void addPaths(@Nullable String resourceType, @NotNull Collection<String> paths, @NotNull Set<String> seenResourceTypes, @NotNull ResourceResolver resourceResolver) {
        Resource resource;
        if (resourceType != null && !seenResourceTypes.contains(resourceType) && (resource = resourceResolver.getResource(resourceType)) != null) {
            boolean matched = false;
            for (Resource child : resource.getChildren()) {
                if (!this.pattern.matcher(child.getName()).matches()) continue;
                paths.add(child.getPath());
                matched = true;
            }
            if (this.inherited && !matched) {
                this.addPaths(resource.getResourceSuperType(), paths, seenResourceTypes, resourceResolver);
            }
        }
    }
}

