/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.link;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LinkUtil.class);
    private static final String[] RESERVED_CHARACTERS_ENCODED = new String[]{"%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2A", "%2B", "%2C", "%2F", "%3A", "%3B", "%3D", "%3F", "%40", "%5B", "%5D", "%2a", "%2b", "%2c", "%2f", "%3a", "%3b", "%3d", "%3f", "%5b", "%5d"};
    private static final List<Pattern> PATTERNS = new ArrayList<Pattern>();

    public static String decode(String url) throws UnsupportedEncodingException {
        LinkedHashMap<String, String> placeholders = new LinkedHashMap<String, String>();
        String masked = LinkUtil.mask(url, placeholders);
        String decoded = URLDecoder.decode(masked, StandardCharsets.UTF_8.name());
        String unmasked = LinkUtil.unmask(decoded, placeholders);
        return unmasked;
    }

    public static String escape(String path, String queryString, String fragment) {
        String escaped;
        URI parsed;
        boolean pathContainsFragment = false;
        if (StringUtils.contains((CharSequence)path, (CharSequence)fragment)) {
            pathContainsFragment = true;
        }
        LinkedHashMap<String, String> placeholders = new LinkedHashMap<String, String>();
        String maskedQueryString = LinkUtil.mask(queryString, placeholders);
        String maskedPath = LinkUtil.mask(path, placeholders);
        try {
            parsed = new URI(maskedPath, false);
        }
        catch (URIException e) {
            parsed = null;
            LOG.error(e.getMessage(), (Throwable)e);
        }
        try {
            escaped = parsed != null ? new URI(parsed.getScheme(), parsed.getAuthority(), parsed.getPath(), maskedQueryString, null).toString() : new URI(null, null, path, maskedQueryString, null).toString();
            if (fragment != null) {
                StringBuilder sb = new StringBuilder(escaped);
                escaped = pathContainsFragment ? (parsed != null ? sb.insert(parsed.toString().length(), "#" + fragment).toString() : sb.insert(path.indexOf(fragment), "#" + fragment).toString()) : sb.append("#").append(LinkUtil.replaceEncodedCharacters(URLEncoder.encode(fragment, StandardCharsets.UTF_8.name()))).toString();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            StringBuilder sb = new StringBuilder(path);
            if (queryString != null) {
                sb.append("?").append(maskedQueryString);
            }
            if (fragment != null) {
                sb.append("#").append(fragment);
            }
            escaped = sb.toString();
        }
        String unmasked = LinkUtil.unmask(escaped, placeholders);
        return unmasked;
    }

    static String mask(String original, Map<String, String> placeholders) {
        if (original == null) {
            return null;
        }
        String masked = original;
        for (Pattern pattern : PATTERNS) {
            Matcher matcher = pattern.matcher(masked);
            while (matcher.find()) {
                String expression = matcher.group(1);
                String placeholder = LinkUtil.newPlaceholder(masked);
                masked = masked.replaceFirst(Pattern.quote(expression), placeholder);
                placeholders.put(placeholder, expression);
            }
        }
        return masked;
    }

    static String unmask(String masked, Map<String, String> placeholders) {
        if (masked == null) {
            return null;
        }
        String unmasked = masked;
        for (Map.Entry<String, String> placeholder : placeholders.entrySet()) {
            unmasked = unmasked.replaceFirst(placeholder.getKey(), placeholder.getValue());
        }
        return unmasked;
    }

    private static String newPlaceholder(String str) {
        SecureRandom random = new SecureRandom();
        StringBuilder placeholderBuilder = new StringBuilder(5);
        do {
            placeholderBuilder.setLength(0);
            placeholderBuilder.append("_").append(new BigInteger(16, random).toString(16)).append("_");
        } while (str.contains(placeholderBuilder));
        return placeholderBuilder.toString();
    }

    private static String replaceEncodedCharacters(String str) {
        return str.replace("%2B", "+").replace("%3D", "=").replace("%7E", "~").replace("%24", "$").replace("%26", "&").replace("%3B", ";").replace("%3A", ":").replace("%40", "@").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%2C", ",");
    }

    static {
        PATTERNS.add(Pattern.compile("(<%[=@].*?%>)"));
        PATTERNS.addAll(Arrays.stream(RESERVED_CHARACTERS_ENCODED).map(encoded -> Pattern.compile("(" + encoded + ")")).collect(Collectors.toList()));
    }
}

