/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.link;

import com.adobe.cq.wcm.core.components.commons.link.LinkBuilder;
import com.adobe.cq.wcm.core.components.commons.link.LinkManager;
import com.adobe.cq.wcm.core.components.internal.link.LinkBuilderImpl;
import com.adobe.cq.wcm.core.components.services.link.PathProcessor;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.designer.Style;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={LinkManager.class})
public class LinkManagerImpl
implements LinkManager {
    public static final Set<String> VALID_LINK_TARGETS = ImmutableSet.of((Object)"_blank", (Object)"_parent", (Object)"_top");
    public static final String PN_DISABLE_SHADOWING = "disableShadowing";
    public static final boolean PROP_DISABLE_SHADOWING_DEFAULT = false;
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    private ValueMap properties;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Style currentStyle;
    @OSGiService
    private List<PathProcessor> pathProcessors;
    private Boolean shadowingDisabled;

    @PostConstruct
    private void initModel() {
        this.shadowingDisabled = false;
        if (this.currentStyle != null) {
            this.shadowingDisabled = (Boolean)this.currentStyle.get(PN_DISABLE_SHADOWING, (Object)this.shadowingDisabled);
        }
        if (this.properties != null) {
            this.shadowingDisabled = (Boolean)this.properties.get(PN_DISABLE_SHADOWING, (Object)this.shadowingDisabled);
        }
    }

    @Override
    @NotNull
    public LinkBuilder get(@NotNull Resource resource) {
        return new LinkBuilderImpl(resource, this.request, this.pathProcessors, (boolean)this.shadowingDisabled);
    }

    @Override
    @NotNull
    public LinkBuilder get(@NotNull Page page) {
        return new LinkBuilderImpl(page, this.request, this.pathProcessors, (boolean)this.shadowingDisabled);
    }

    @Override
    @NotNull
    public LinkBuilder get(@NotNull Asset asset) {
        return new LinkBuilderImpl(asset, this.request, this.pathProcessors);
    }

    @Override
    @NotNull
    public LinkBuilder get(@NotNull String url) {
        return new LinkBuilderImpl(url, this.request, this.pathProcessors, (boolean)this.shadowingDisabled);
    }

    public static boolean isExternalLink(String url) {
        return StringUtils.isNotBlank((CharSequence)url) && !url.startsWith("/");
    }
}

