/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.link;

import com.adobe.cq.wcm.core.components.internal.link.LinkUtil;
import com.adobe.cq.wcm.core.components.services.link.PathProcessor;
import com.day.cq.commons.Externalizer;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class)
@Component(property={"service.ranking:Integer=-2147483648"}, service={PathProcessor.class})
public class DefaultPathProcessor
implements PathProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPathProcessor.class);
    @Reference
    Externalizer externalizer;
    private VanityConfig vanityConfig;

    @Activate
    protected void activate(BundleContext bundleContext, Config config) {
        this.vanityConfig = VanityConfig.fromString(config.vanityConfig());
    }

    @Override
    public boolean accepts(@NotNull String path, @NotNull SlingHttpServletRequest request) {
        return true;
    }

    @Override
    @NotNull
    public String sanitize(@NotNull String path, @NotNull SlingHttpServletRequest request) {
        String fragment;
        String queryString;
        if (this.vanityConfig == VanityConfig.ALWAYS) {
            path = this.getPathOrVanityUrl(path, request.getResourceResolver());
        }
        int queryStringMark = path.indexOf(63);
        int fragmentMark = path.indexOf(35);
        if (queryStringMark >= 0 || fragmentMark >= 0) {
            if (queryStringMark >= 0) {
                if (fragmentMark >= 0) {
                    if (queryStringMark < fragmentMark) {
                        queryString = path.substring(queryStringMark + 1, fragmentMark);
                        fragment = path.substring(fragmentMark + 1);
                    } else {
                        fragment = path.substring(fragmentMark + 1, queryStringMark);
                        queryString = path.substring(queryStringMark + 1);
                    }
                } else {
                    queryString = path.substring(queryStringMark + 1);
                    fragment = null;
                }
            } else {
                queryString = null;
                fragment = path.substring(fragmentMark + 1);
            }
            path = path.substring(0, queryStringMark >= 0 ? queryStringMark : fragmentMark);
        } else {
            queryString = null;
            fragment = null;
        }
        String cp = request.getContextPath();
        if (!StringUtils.isEmpty((CharSequence)cp) && path.startsWith("/") && !path.startsWith(cp + "/")) {
            path = cp + path;
        }
        path = LinkUtil.escape(path, queryString, fragment);
        return path;
    }

    @Override
    @NotNull
    public String map(@NotNull String path, @NotNull SlingHttpServletRequest request) {
        String mappedPath;
        ResourceResolver resourceResolver = request.getResourceResolver();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        String maskedPath = LinkUtil.mask(path, placeholders);
        try {
            mappedPath = this.vanityConfig == VanityConfig.MAPPING || this.vanityConfig == VanityConfig.ALWAYS ? LinkUtil.unmask(StringUtils.defaultString((String)resourceResolver.map((HttpServletRequest)request, this.getPathOrVanityUrl(maskedPath, resourceResolver))), placeholders) : LinkUtil.unmask(StringUtils.defaultString((String)resourceResolver.map((HttpServletRequest)request, maskedPath)), placeholders);
        }
        catch (Exception e) {
            mappedPath = path;
        }
        return mappedPath;
    }

    @Override
    @NotNull
    public String externalize(@NotNull String path, @NotNull SlingHttpServletRequest request) {
        String externalPath;
        ResourceResolver resourceResolver = request.getResourceResolver();
        try {
            externalPath = this.vanityConfig == VanityConfig.MAPPING || this.vanityConfig == VanityConfig.ALWAYS ? this.externalizer.publishLink(resourceResolver, this.getPathOrVanityUrl(path, resourceResolver)) : this.externalizer.publishLink(resourceResolver, path);
        }
        catch (Exception e) {
            externalPath = path;
        }
        return externalPath;
    }

    @NotNull
    private String getPathOrVanityUrl(@NotNull String path, @NotNull ResourceResolver resourceResolver) {
        return Optional.ofNullable(this.getVanityUrl(path, resourceResolver)).filter(StringUtils::isNotBlank).orElse(path);
    }

    @Nullable
    private String getVanityUrl(@NotNull String path, @NotNull ResourceResolver resourceResolver) {
        Page page;
        PageManager pageManager;
        String vanityUrl = null;
        if (path.endsWith(".html") && (pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class)) != null && (page = pageManager.getPage(path.substring(0, path.lastIndexOf(".html")))) != null && StringUtils.isNotBlank((CharSequence)(vanityUrl = page.getVanityUrl())) && !vanityUrl.startsWith("/")) {
            vanityUrl = "/" + vanityUrl;
        }
        return vanityUrl;
    }

    public static enum VanityConfig {
        NEVER("never"),
        ALWAYS("always"),
        MAPPING("mapping");

        private String value;

        public String getValue() {
            return this.value;
        }

        private VanityConfig(String value) {
            this.value = value;
        }

        public static VanityConfig fromString(String value) {
            for (VanityConfig config : VanityConfig.values()) {
                if (!StringUtils.equals((CharSequence)config.value, (CharSequence)value)) continue;
                return config;
            }
            return NEVER;
        }
    }

    @ObjectClassDefinition(name="Core Components Default Path Processor")
    static @interface Config {
        @AttributeDefinition(name="Vanity path rewriting", description="Defines how the vanity url of a page is taken into account while generating the link URLs", options={@Option(label="never", value="never"), @Option(label="always", value="always"), @Option(label="on path mapping and externalization", value="mapping")})
        public String vanityConfig() default "never";
    }
}

