/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.jackson;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sling.models.jacksonexporter.ModuleProvider;
import org.osgi.service.component.annotations.Component;

@Component
public class DefaultMethodSkippingModuleProvider
implements ModuleProvider {
    private static final String PACKAGE_CORE_COMPONENTS = "com.adobe.cq.wcm.core.components";
    private static final String PACKAGE_IMPL_INTERNAL = "internal.models";
    private static final String PACKAGE_UTIL = "com.adobe.cq.wcm.core.components.util";
    private SimpleModule module = new SimpleModule();

    public DefaultMethodSkippingModuleProvider() {
        this.module.setSerializerModifier(new BeanSerializerModifier(){

            public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
                return super.changeProperties(config, beanDesc, beanProperties.stream().filter(bpw -> {
                    Method method;
                    AnnotatedMember jacksonMember = bpw.getMember();
                    Member member = jacksonMember.getMember();
                    if (member instanceof Method && (method = (Method)member).isDefault()) {
                        try {
                            String className = beanDesc.getBeanClass().getMethod(method.getName(), new Class[0]).getDeclaringClass().getName();
                            return !className.startsWith(DefaultMethodSkippingModuleProvider.PACKAGE_CORE_COMPONENTS) || className.contains(DefaultMethodSkippingModuleProvider.PACKAGE_IMPL_INTERNAL) || className.contains(DefaultMethodSkippingModuleProvider.PACKAGE_UTIL);
                        }
                        catch (NoSuchMethodException e) {
                            return false;
                        }
                    }
                    return true;
                }).collect(Collectors.toList()));
            }
        });
    }

    public Module getModule() {
        return this.module;
    }
}

