/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.helper.image;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.google.common.base.Joiner;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdaptiveImageHelper {
    public static final String IMAGE_RESOURCE_TYPE = "core/wcm/components/image";

    private AdaptiveImageHelper() {
    }

    @Nullable
    public static Resource getComponentCandidate(@NotNull String suffix, Resource component) {
        String suffixPath;
        Resource componentCandidate = null;
        long lastModifiedSuffix = AdaptiveImageHelper.getRequestLastModifiedSuffix(suffix);
        String string = suffixPath = lastModifiedSuffix == 0L ? suffix.substring(0, suffix.lastIndexOf(46)) : suffix.substring(0, suffix.lastIndexOf("/" + String.valueOf(lastModifiedSuffix)));
        if (StringUtils.isNotEmpty((CharSequence)suffixPath)) {
            Resource externalImageResource;
            ResourceResolver resourceResolver = component.getResourceResolver();
            if (!component.isResourceType(IMAGE_RESOURCE_TYPE)) {
                componentCandidate = Optional.ofNullable(resourceResolver.adaptTo(PageManager.class)).map(pageManager -> pageManager.getContainingPage(component)).map(Page::getTemplate).map(template -> ResourceUtil.normalize((String)(template.getPath() + suffixPath))).map(arg_0 -> ((ResourceResolver)resourceResolver).getResource(arg_0)).orElse(null);
            }
            if (componentCandidate == null && (externalImageResource = resourceResolver.getResource(suffixPath)) != null && externalImageResource.isResourceType(IMAGE_RESOURCE_TYPE)) {
                componentCandidate = externalImageResource;
            }
        }
        return componentCandidate;
    }

    public static long getRequestLastModifiedSuffix(@Nullable String suffix) {
        long requestLastModified = 0L;
        if (StringUtils.isNotEmpty((CharSequence)suffix) && suffix.contains(".")) {
            Pattern p = Pattern.compile("\\(|\\)|\\/\\d{13}");
            Matcher m = p.matcher(suffix);
            if (!m.find()) {
                return requestLastModified;
            }
            try {
                requestLastModified = Long.parseLong(ResourceUtil.getName((String)m.group()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return requestLastModified;
    }

    @Nullable
    public static String getRedirectLocation(SlingHttpServletRequest request, long lastModifiedEpoch) {
        String redirectLocation = null;
        long lastModifiedSuffix = 0L;
        RequestPathInfo requestPathInfo = request.getRequestPathInfo();
        String suffix = requestPathInfo.getSuffix();
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            lastModifiedSuffix = AdaptiveImageHelper.getRequestLastModifiedSuffix(suffix);
        }
        if (lastModifiedSuffix > 0L) {
            suffix = StringUtils.replace((String)suffix, (String)String.valueOf(lastModifiedSuffix), (String)String.valueOf(lastModifiedEpoch));
            redirectLocation = Joiner.on((char)'.').join((Object)Text.escapePath((String)(request.getContextPath() + requestPathInfo.getResourcePath())), (Object)requestPathInfo.getSelectorString(), new Object[]{requestPathInfo.getExtension() + Text.escapePath((String)suffix)});
        } else if (request.getResource().isResourceType(IMAGE_RESOURCE_TYPE)) {
            redirectLocation = Joiner.on((char)'.').join((Object)Text.escapePath((String)(request.getContextPath() + requestPathInfo.getResourcePath())), (Object)requestPathInfo.getSelectorString(), new Object[]{requestPathInfo.getExtension() + "/" + lastModifiedEpoch, requestPathInfo.getExtension()});
        } else {
            String resourcePath = request.getPathInfo();
            String extension = FilenameUtils.getExtension((String)resourcePath);
            if (StringUtils.isNotEmpty((CharSequence)resourcePath)) {
                if (StringUtils.isNotEmpty((CharSequence)extension)) {
                    resourcePath = resourcePath.substring(0, resourcePath.length() - extension.length() - 1);
                }
                redirectLocation = request.getContextPath() + Text.escapePath((String)resourcePath) + "/" + lastModifiedEpoch + "." + requestPathInfo.getExtension();
            }
        }
        return redirectLocation;
    }
}

