/*
 * Decompiled with CFR 0.152.
 */
package com.azuredemo.core.servlets;

import com.azuredemo.core.SaveAndFetchFromAzure.StoreAndFetchDataFromAzureStorage;
import java.io.IOException;
import java.io.Serializable;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"azure/listFormsInFolder"}, methods={"GET"}, extensions={"json"})
public class GetForms
extends SlingAllMethodsServlet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    transient StoreAndFetchDataFromAzureStorage azurePortalBlobs;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        this.log.debug("The form path I got was " + request.getParameter("folderPath"));
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        String jsonArray = this.azurePortalBlobs.getFormsList(request.getParameter("folderPath"), session);
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            this.log.debug("The json response is " + jsonArray);
            response.getWriter().write(jsonArray);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

