/*
 * Decompiled with CFR 0.152.
 */
package com.azuredemo.core.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, property={"sling.filter.scope=REQUEST"})
@ServiceDescription(value="Demo to filter incoming requests")
@ServiceRanking(value=-700)
@ServiceVendor(value="Adobe")
public class LoggingFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        this.logger.debug("request for {}, with selector {}", (Object)slingRequest.getRequestPathInfo().getResourcePath(), (Object)slingRequest.getRequestPathInfo().getSelectorString());
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

