/*
 * Decompiled with CFR 0.152.
 */
package com.azuredemo.core;

import com.adobe.aemds.guide.common.GuideValidationResult;
import com.adobe.aemds.guide.model.FormSubmitInfo;
import com.adobe.aemds.guide.service.FormSubmitActionService;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import com.azuredemo.core.DataManager;
import com.azuredemo.core.SaveAndFetchFromAzure.StoreAndFetchDataFromAzureStorage;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Session;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormSubmitActionService.class}, immediate=true)
public class StoreFormDataWithBlobIndexTagsInAzure
implements FormSubmitActionService {
    private static final String serviceName = "Store Form Submission with MetaData tags in Azure";
    private static transient Logger logger = LoggerFactory.getLogger(StoreFormDataWithBlobIndexTagsInAzure.class);
    @Reference
    DataManager dataManager;
    @Reference
    StoreAndFetchDataFromAzureStorage storeAndFetchDataFromAzureStorage;

    public String getServiceName() {
        return serviceName;
    }

    public Map<String, Object> submit(FormSubmitInfo formSubmitInfo) {
        logger.debug("@@@@in my custom submit!!!");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("FormSubmissionComplete", Boolean.FALSE);
        try {
            String guideContainerPath = formSubmitInfo.getFormContainerPath();
            String submittedFormName = formSubmitInfo.getFormContainerResource().getParent().getParent().getName();
            logger.debug("The submitted form name is " + submittedFormName);
            String data = formSubmitInfo.getData();
            logger.debug("The submitted data is " + data);
            JsonObject jsonData = (JsonObject)new Gson().fromJson(data, JsonObject.class);
            if (formSubmitInfo.getFileAttachments() != null && formSubmitInfo.getFileAttachments().size() > 0) {
                logger.debug("#####The form submitted has file attachments");
                for (int i = 0; i < formSubmitInfo.getFileAttachments().size(); ++i) {
                    FileAttachmentWrapper fileAttachment = (FileAttachmentWrapper)formSubmitInfo.getFileAttachments().get(i);
                    logger.debug("The url of the file attachment is " + fileAttachment.getUri());
                    logger.debug("The data ref of the file attachment is " + fileAttachment.getDataRef());
                    String fileName = fileAttachment.getFileName();
                    logger.debug("The fileName is  " + fileName);
                    logger.debug("#### Writing  " + fileName + " to azure");
                    String dataUrl = this.storeAndFetchDataFromAzureStorage.saveFormAttachmentinAzure(fileAttachment.getInputStream(), fileName, fileAttachment.getContentType());
                    jsonData.getAsJsonObject(fileAttachment.getDataRef()).addProperty("data", dataUrl);
                    logger.debug(jsonData.toString());
                }
            }
            logger.debug("Getting metadata tags!!!!! ");
            String metadataTags = this.storeAndFetchDataFromAzureStorage.getMetaDataTags(submittedFormName, formSubmitInfo.getFormContainerPath(), (Session)formSubmitInfo.getFormContainerResource().getResourceResolver().adaptTo(Session.class), data);
            final String uniqueID = UUID.randomUUID().toString();
            logger.debug("The metadata tags are  " + metadataTags);
            logger.debug(this.storeAndFetchDataFromAzureStorage.saveFormDatainAzure(jsonData.toString(), "text/plain", metadataTags));
            if (this.dataManager != null) {
                this.dataManager.put(uniqueID, data);
            }
            logger.info("AF Submission successful using custom submit service for: {}", (Object)guideContainerPath);
            result.put("FormSubmissionComplete", Boolean.TRUE);
            result.put("prefillId", uniqueID);
            HashMap<String, Object> redirectParamMap = new HashMap<String, Object>(){
                {
                    this.put("prefillId", uniqueID);
                }
            };
            result.put("fd:redirectParameters", redirectParamMap);
        }
        catch (Exception ex) {
            logger.error("Error while using the AF Submit service", (Throwable)ex);
            GuideValidationResult guideValidationResult = new GuideValidationResult();
        }
        return result;
    }
}

