/*
 * Decompiled with CFR 0.152.
 */
package com.azuredemo.core;

import com.adobe.forms.common.service.ContentType;
import com.adobe.forms.common.service.DataOptions;
import com.adobe.forms.common.service.DataProvider;
import com.adobe.forms.common.service.FormsException;
import com.adobe.forms.common.service.PrefillData;
import com.azuredemo.core.SaveAndFetchFromAzure.StoreAndFetchDataFromAzureStorage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DataProvider.class, PrefillFromAzure.class}, immediate=true)
public class PrefillFromAzure
implements DataProvider {
    @Reference
    private StoreAndFetchDataFromAzureStorage saveAndFetchFromAzure;
    private transient Logger logger = LoggerFactory.getLogger(PrefillFromAzure.class);

    public PrefillData getPrefillData(DataOptions dataOptions) throws FormsException {
        String guid = (String)dataOptions.getExtras().get("guid");
        String data = this.saveAndFetchFromAzure.getBlobData(guid);
        InputStream dataInputStream = null;
        ContentType contentType = dataOptions.getContentType();
        PrefillData prefillData = null;
        if (StringUtils.isNotBlank((CharSequence)data)) {
            this.logger.debug("Returning prefill data");
            dataInputStream = this.getDataInputStream(data);
            prefillData = new PrefillData(dataInputStream, contentType);
        }
        return prefillData;
    }

    public String getServiceName() {
        return "Prefill from azure portal";
    }

    public String getServiceDescription() {
        return "Service to fetch data from azure portal storage";
    }

    private InputStream getDataInputStream(String data) {
        ByteArrayInputStream dataInputStream = null;
        this.logger.debug("got data  " + data);
        try {
            dataInputStream = new ByteArrayInputStream(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("[Custom AF Prefill] Exception in custom af prefill service", (Throwable)e);
        }
        return dataInputStream;
    }
}

