/*
 * Decompiled with CFR 0.152.
 */
package com.azuredemo.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(service={DataManager.class}, immediate=true)
public class DataManager
implements Serializable {
    private static int MAX_ENTRIES = 10000;
    private static int INITIAL_CAPACITY = 100;
    public static final String UNIQUE_ID = "prefillId";
    private Map<Object, Object> cache;

    public static String getFileAttachmentMapKey(String uuid) {
        return uuid + "fileAttachmentMap";
    }

    protected void activate() {
        this.cache = Collections.synchronizedMap(new LinkedHashMap<Object, Object>(INITIAL_CAPACITY + 1, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > MAX_ENTRIES;
            }
        });
    }

    public Object get(String key) {
        Object value = null;
        if (this.cache.containsKey(key)) {
            value = this.cache.get(key);
        }
        return value;
    }

    public Map<String, String> getCustomContext(String id) {
        HashMap<String, String> customContext = new HashMap<String, String>();
        customContext.put(UNIQUE_ID, id);
        return customContext;
    }

    public Object put(String key, Object value) {
        return this.cache.put(key, value);
    }
}

