/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.internal.models.v2;

import com.adobe.cq.wcm.core.components.config.AttributeConfig;
import com.adobe.cq.wcm.core.components.config.HtmlPageItemConfig;
import com.adobe.cq.wcm.core.components.models.HtmlPageItem;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

public class HtmlPageItemImpl
implements HtmlPageItem {
    String prefixPath;
    Resource resource;
    ValueMap properties;
    HtmlPageItemConfig config;
    HtmlPageItem.Element element;
    HtmlPageItem.Location location;
    Map<String, Object> attributes;

    public HtmlPageItemImpl(@NotNull String prefixPath, @NotNull Resource resource) {
        this.prefixPath = prefixPath;
        this.resource = resource;
        this.properties = resource.getValueMap();
    }

    public HtmlPageItemImpl(@NotNull String prefixPath, @NotNull HtmlPageItemConfig config) {
        this.prefixPath = prefixPath;
        this.config = config;
    }

    public HtmlPageItem.Element getElement() {
        if (this.element == null) {
            this.element = this.config != null ? HtmlPageItem.Element.fromString((String)this.config.element()) : HtmlPageItem.Element.fromString((String)((String)this.properties.get("element", String.class)));
        }
        return this.element;
    }

    public HtmlPageItem.Location getLocation() {
        if (this.location == null) {
            this.location = this.config != null ? HtmlPageItem.Location.fromString((String)this.config.location()) : HtmlPageItem.Location.fromString((String)((String)this.properties.get("location", String.class)));
        }
        return this.location;
    }

    public Map<String, Object> getAttributes() {
        block2: {
            block3: {
                if (this.attributes != null) break block2;
                this.attributes = new LinkedHashMap<String, Object>();
                if (this.config == null) break block3;
                for (AttributeConfig attributeConfig : this.config.attributes()) {
                    String attrName = attributeConfig.name();
                    String attrValue = attributeConfig.value();
                    if (!StringUtils.isNotEmpty((CharSequence)attrName)) continue;
                    this.addAttributes(attrName, attrValue);
                }
                break block2;
            }
            Resource attributesNode = this.resource.getChild("attributes");
            if (attributesNode == null) break block2;
            ValueMap attributesProperties = attributesNode.getValueMap();
            for (String attrName : this.getElement().getAttributeNames()) {
                String attrValue = (String)attributesProperties.get(attrName, String.class);
                if (attrValue == null) continue;
                this.addAttributes(attrName, attrValue);
            }
        }
        return this.attributes;
    }

    private void addAttributes(String name, String value) {
        if (this.getElement() == HtmlPageItem.Element.LINK && "href".equals(name) || this.getElement() == HtmlPageItem.Element.SCRIPT && "src".equals(name)) {
            value = this.prefixPath + value;
        }
        if (StringUtils.equals((CharSequence)value, (CharSequence)"true")) {
            this.attributes.put(name, true);
        } else if (StringUtils.equals((CharSequence)value, (CharSequence)"false")) {
            this.attributes.put(name, false);
        } else {
            this.attributes.put(name, value);
        }
    }
}

