/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.internal.models.v1.aemform;

import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.forms.core.components.models.aemform.AEMForm;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.designer.Style;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={AEMForm.class, ComponentExporter.class}, resourceType={"core/fd/components/aemform/v1/aemform"})
@Exporter(name="jackson", extensions={"json"})
public class AEMFormImpl
extends AbstractComponentImpl
implements AEMForm {
    public static final String RESOURCE_TYPE = "core/fd/components/aemform/v1/aemform";
    private static final Logger LOGGER = LoggerFactory.getLogger(AEMFormImpl.class);
    @ScriptVariable
    protected PageManager pageManager;
    @ScriptVariable
    private Page currentPage;
    @ScriptVariable
    protected Style currentStyle;
    @ScriptVariable
    protected ValueMap properties;
    @ValueMapValue(name="thankyouPage", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    protected String thankyouPage;
    @ValueMapValue(name="thankyouConfig", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={"page"})
    protected String thankyouConfig;
    @ValueMapValue(name="submitType", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={"inline"})
    protected String submitType;
    @ValueMapValue(name="height", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={"auto"})
    protected String height;
    @ValueMapValue(name="thankyouMessage", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    protected String thankyouMessage;
    @ValueMapValue(name="formType", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String formType;
    @ValueMapValue(name="themeRef", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private String themeRef;
    @ValueMapValue(name="docRef", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private String docRef;
    @ValueMapValue(name="formRef", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private String formRef;
    @ValueMapValue(name="cssClientlib", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={""})
    private String cssClientLib;
    @ValueMapValue(name="useiframe", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={"false"})
    private String useIframe;
    @ValueMapValue(name="enableFocusOnFirstField", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(booleanValues={true})
    private boolean enableFocusOnFirstField;
    @ValueMapValue(name="usePageLocale", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(values={"false"})
    private String usePageLocale;

    protected String getClientLibCategory(String themePath) {
        Resource themeResource;
        String clientLibCategory = "";
        if (StringUtils.isNotBlank((CharSequence)themePath) && (themeResource = this.request.getResourceResolver().getResource(themePath + "/jcr:content/metadata")) != null) {
            ValueMap themeProps = themeResource.getValueMap();
            clientLibCategory = (String)themeProps.get("clientlibCategory", (Object)"");
        }
        return clientLibCategory;
    }

    @Override
    public String getThankyouConfig() {
        return this.thankyouConfig;
    }

    @Override
    public String getThankyouMessage() {
        return this.thankyouMessage;
    }

    @Override
    public String getThemeName() {
        return this.getClientLibCategory(this.themeRef);
    }

    private String getFormPath() {
        if ("adaptiveDocument".equals(this.formType)) {
            return this.docRef;
        }
        return this.formRef;
    }

    @Override
    public String getFormPagePath() {
        String formPath = this.getFormPath();
        Boolean isMCDocument = this.isMCDocument();
        if (isMCDocument.booleanValue()) {
            return GuideUtils.guideRefToDocPath((String)formPath);
        }
        return GuideUtils.guideRefToGuidePath((String)formPath);
    }

    @Override
    public String getFormEditPagePath() {
        String formPagePath = this.getFormPagePath();
        return StringUtils.substringBefore((String)formPagePath, (String)"/jcr:content");
    }

    @Override
    public String getThemePath() {
        return StringUtils.isNotBlank((CharSequence)this.themeRef) ? this.themeRef + "/" + "jcr:content" : "";
    }

    @Override
    public String getLocale() {
        String lang = "";
        if (this.usePageLocale != null && StringUtils.equals((CharSequence)this.usePageLocale, (CharSequence)"true")) {
            lang = this.getPageLocale();
        }
        if (StringUtils.isBlank((CharSequence)lang) && (this.isAdaptiveForm() || this.isMCDocument())) {
            lang = GuideUtils.getLocale((SlingHttpServletRequest)this.request, (Resource)this.request.getResourceResolver().getResource(this.getFormPagePath()));
        }
        return lang;
    }

    private String getPageLocale() {
        String pagePath = this.currentPage.getPath();
        String pageLocaleRoot = LanguageUtil.getLanguageRoot((String)pagePath);
        String locale = "";
        if (StringUtils.isNotBlank((CharSequence)pageLocaleRoot)) {
            int localeStartIndex = StringUtils.lastIndexOf((CharSequence)pageLocaleRoot, (int)47);
            locale = StringUtils.substring((String)pageLocaleRoot, (int)(localeStartIndex + 1));
        }
        return locale;
    }

    @Override
    public String getSubmitType() {
        String sbmType = this.submitType;
        if ("message".equals(this.getThankyouConfig())) {
            sbmType = "inline";
        }
        return sbmType;
    }

    @Override
    public String getCssClientlib() {
        return this.cssClientLib;
    }

    @Override
    public AEMForm.FormType getFormType() {
        AEMForm.FormType formType = AEMForm.FormType.NO_FORM_SELECTED;
        String formPath = this.getFormPath();
        if (!"".equals(formPath)) {
            ResourceResolver resolver = this.request.getResourceResolver();
            if (this.getFormVersion().equals("2.1") || GuideUtils.isValidFormResource((ResourceResolver)resolver, (String)formPath, (String)"guide")) {
                formType = AEMForm.FormType.ADAPTIVE_FORM;
            } else if (GuideUtils.isValidFormResource((ResourceResolver)resolver, (String)formPath, (String)"mcdocument")) {
                formType = AEMForm.FormType.MC_DOCUMENT;
            } else if (GuideUtils.isValidFormResource((ResourceResolver)resolver, (String)formPath, (String)"xfaForm")) {
                formType = AEMForm.FormType.MOBILE_FORM;
            }
        }
        return formType;
    }

    @Override
    public String getUseIframe() {
        return this.useIframe;
    }

    @Override
    public boolean getEnableFocusOnFirstField() {
        return this.enableFocusOnFirstField;
    }

    @Override
    public boolean isAdaptiveForm() {
        return AEMForm.FormType.ADAPTIVE_FORM.equals((Object)this.getFormType());
    }

    @Override
    public boolean isMCDocument() {
        return AEMForm.FormType.MC_DOCUMENT.equals((Object)this.getFormType());
    }

    @Override
    public boolean isMobileForm() {
        return AEMForm.FormType.MOBILE_FORM.equals((Object)this.getFormType());
    }

    @Override
    public boolean isMobileFormset() {
        return AEMForm.FormType.MOBILE_FORMSET.equals((Object)this.getFormType());
    }

    @Override
    public boolean isFormSelected() {
        return !AEMForm.FormType.NO_FORM_SELECTED.equals((Object)this.getFormType());
    }

    @Override
    public String getThankyouPage() {
        return GuideUtils.getRedirectUrl((String)this.thankyouPage, null);
    }

    @Override
    public String getHeight() {
        if (!"auto".equals(this.height)) {
            try {
                this.height = Integer.parseInt(this.height) + "px";
            }
            catch (NumberFormatException ex) {
                this.height = "auto";
            }
        }
        return this.height;
    }

    @Override
    public String getFormVersion() {
        Resource guideContainerResource;
        Resource jcrContentResource;
        Resource formResource;
        String version = "";
        String formPath = this.getFormPath();
        ResourceResolver resourceResolver = this.request.getResourceResolver();
        if (!formPath.isEmpty() && resourceResolver != null && (formResource = resourceResolver.getResource(formPath = GuideUtils.convertFMAssetPathToFormPagePath((String)formPath))) != null && (jcrContentResource = formResource.getChild("jcr:content")) != null && (guideContainerResource = jcrContentResource.getChild("guideContainer")) != null) {
            version = guideContainerResource.getValueMap().get((Object)"fd:version").toString();
        }
        return version;
    }
}

