/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import com.adobe.cq.forms.core.components.models.form.OptionsConstraint;
import com.adobe.cq.forms.core.components.util.AbstractFieldImpl;
import com.adobe.cq.forms.core.components.util.ComponentUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOptionsFieldImpl
extends AbstractFieldImpl
implements OptionsConstraint {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Default(booleanValues={true})
    private boolean enforceEnum;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="enum")
    @Nullable
    protected String[] enums;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="enumNames")
    @Nullable
    protected String[] enumNames;

    @Override
    public boolean isEnforceEnum() {
        return this.enforceEnum;
    }

    private Map<Object, String> removeDuplicates() {
        Object[] enumArray = this.enums;
        String[] enumNamesArray = this.enumNames;
        LinkedHashMap map = new LinkedHashMap();
        if (enumArray != null && enumNamesArray != null && enumArray.length == enumNamesArray.length) {
            map = IntStream.range(0, enumArray.length).collect(LinkedHashMap::new, (m, i) -> m.put(enumArray[i], enumNamesArray[i]), HashMap::putAll);
        }
        return map;
    }

    @Override
    public Object[] getEnums() {
        if (this.enums == null) {
            return null;
        }
        Map<Object, String> map = this.removeDuplicates();
        Object[] enumValue = map.keySet().toArray(new String[0]);
        return ComponentUtils.coerce(this.type, enumValue);
    }

    @Override
    public String[] getEnumNames() {
        if (this.enumNames != null) {
            Map<Object, String> map = this.removeDuplicates();
            String[] enumName = map.values().toArray(new String[0]);
            return (String[])Arrays.stream(enumName).map(p -> this.translate("enumNames", (String)p)).toArray(String[]::new);
        }
        return null;
    }

    @Override
    public Object[] getDefault() {
        Object[] typedDefaultValue = null;
        try {
            if (this.defaultValue != null) {
                typedDefaultValue = ComponentUtils.coerce(this.type, this.defaultValue);
            }
        }
        catch (Exception exception) {
            this.logger.error("Error while type casting default value to value type. Exception: ", (Throwable)exception);
        }
        return typedDefaultValue;
    }
}

