/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import com.adobe.cq.forms.core.components.models.form.AssistPriority;
import com.adobe.cq.forms.core.components.models.form.Base;
import com.adobe.cq.forms.core.components.models.form.BaseConstraint;
import com.adobe.cq.forms.core.components.models.form.ConstraintType;
import com.adobe.cq.forms.core.components.models.form.Label;
import com.adobe.cq.forms.core.components.util.AbstractFormComponentImpl;
import com.adobe.cq.forms.core.components.util.LabelImpl;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBaseImpl
extends AbstractFormComponentImpl
implements Base,
BaseConstraint {
    private static final String PN_DESCRIPTION = "description";
    private static final String PN_TOOLTIP = "tooltip";
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected String dorTemplateRef;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected String dorType;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Named(value="fd:formtype")
    @Nullable
    protected String dorTemplateType;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="description")
    @Nullable
    protected String description;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="tooltip")
    @Nullable
    protected String tooltip;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="tooltipVisible")
    @Default(booleanValues={false})
    protected boolean tooltipVisible;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="type")
    @Nullable
    protected String typeJcr;
    protected BaseConstraint.Type type;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected String validationExpression;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="required")
    @Nullable
    protected Boolean required;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="assistPriority")
    @Nullable
    protected String assistPriorityJcr;
    private AssistPriority assistPriority;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="custom")
    @Nullable
    protected String customAssistPriorityMsg;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    protected Boolean enabled;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    protected Boolean repeatable;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    protected Integer minOccur;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    protected Integer maxOccur;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    protected Integer minItems;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    protected Integer maxItems;
    @SlingObject
    private Resource resource;
    private Map<ConstraintType, String> constraintMessages = null;

    @Override
    @PostConstruct
    protected void initBaseModel() {
        super.initBaseModel();
        this.assistPriority = AssistPriority.fromString(this.assistPriorityJcr);
        this.type = BaseConstraint.Type.fromString(this.typeJcr);
    }

    @Override
    public Label getLabel() {
        return new LabelImpl(this.resource, "", this.i18n);
    }

    @Override
    @Nullable
    public String getTooltip() {
        return this.translate(PN_TOOLTIP, this.tooltip);
    }

    @Override
    public boolean isTooltipVisible() {
        return this.tooltipVisible;
    }

    @Override
    @JsonIgnore
    @NotNull
    public Map<String, Object> getCustomLayoutProperties() {
        Map<String, Object> customLayoutProperties = super.getCustomLayoutProperties();
        if (this.tooltip != null) {
            customLayoutProperties.put("tooltipVisible", this.tooltipVisible);
        }
        return customLayoutProperties;
    }

    @Override
    @Nullable
    public String getScreenReaderText() {
        String screenReaderText = null;
        if (AssistPriority.LABEL.equals((Object)this.assistPriority)) {
            Label label = this.getLabel();
            if (label != null) {
                screenReaderText = "$label.$value";
            }
        } else if (AssistPriority.NAME.equals((Object)this.assistPriority)) {
            screenReaderText = "$name";
        } else if (AssistPriority.DESCRIPTION.equals((Object)this.assistPriority)) {
            screenReaderText = "$description";
        } else if (AssistPriority.CUSTOM.equals((Object)this.assistPriority)) {
            screenReaderText = "'" + this.customAssistPriorityMsg + "'";
        }
        return screenReaderText;
    }

    @Override
    @Nullable
    public String getHtmlScreenReaderText() {
        String screenReaderText = this.getName();
        if (AssistPriority.LABEL.equals((Object)this.assistPriority)) {
            Label label = this.getLabel();
            if (label != null) {
                screenReaderText = label.getValue();
            }
        } else if (AssistPriority.NAME.equals((Object)this.assistPriority)) {
            screenReaderText = this.getName();
        } else if (AssistPriority.DESCRIPTION.equals((Object)this.assistPriority)) {
            screenReaderText = this.getDescription();
        } else if (AssistPriority.CUSTOM.equals((Object)this.assistPriority)) {
            screenReaderText = this.customAssistPriorityMsg;
        }
        return screenReaderText;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.translate(PN_DESCRIPTION, this.description);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Boolean isEnabled() {
        return this.enabled;
    }

    @JsonIgnore
    public String getTooltipText() {
        String tooltip = this.getTooltip();
        if (StringUtils.isNotEmpty((CharSequence)tooltip)) {
            tooltip = tooltip.replaceAll("<\\/?[^>]+(>|$)|&nbsp;", "");
            return tooltip;
        }
        return "";
    }

    protected String getConstraintMessage(ConstraintType type) {
        String propName = type.getMessageProperty();
        ValueMap properties = this.resource.getValueMap();
        return this.translate(propName, (String)properties.get(propName, String.class));
    }

    @Override
    @NotNull
    public Map<ConstraintType, String> getConstraintMessages() {
        if (this.constraintMessages == null) {
            this.constraintMessages = new LinkedHashMap<ConstraintType, String>();
            ConstraintMessagesProvider msgs = new ConstraintMessagesProvider();
            this.putConstraintMessage(ConstraintType.TYPE, msgs.getTypeConstraintMessage());
            this.putConstraintMessage(ConstraintType.REQUIRED, msgs.getRequiredConstraintMessage());
            BaseConstraint.Type type = this.getType();
            if (type != null) {
                if (type.equals((Object)BaseConstraint.Type.STRING)) {
                    this.putConstraintMessage(ConstraintType.MIN_LENGTH, msgs.getMinLengthConstraintMessage());
                    this.putConstraintMessage(ConstraintType.MAX_LENGTH, msgs.getMaxLengthConstraintMessage());
                    this.putConstraintMessage(ConstraintType.PATTERN, msgs.getPatternConstraintMessage());
                    this.putConstraintMessage(ConstraintType.FORMAT, msgs.getFormatConstraintMessage());
                }
                if (type.equals((Object)BaseConstraint.Type.NUMBER)) {
                    this.putConstraintMessage(ConstraintType.MINIMUM, msgs.getMinimumConstraintMessage());
                    this.putConstraintMessage(ConstraintType.MAXIMUM, msgs.getMaximumConstraintMessage());
                }
            }
            this.putConstraintMessage(ConstraintType.MAXFILE_SIZE, msgs.getMaxFileSizeConstraintMessage());
            this.putConstraintMessage(ConstraintType.ACCEPT, msgs.getAcceptConstraintMessage());
            this.putConstraintMessage(ConstraintType.STEP, msgs.getStepConstraintMessage());
            this.putConstraintMessage(ConstraintType.MIN_ITEMS, msgs.getMinItemsConstraintMessage());
            this.putConstraintMessage(ConstraintType.MAX_ITEMS, msgs.getMaxItemsConstraintMessage());
            this.putConstraintMessage(ConstraintType.ENFORCE_ENUM, msgs.getEnforceEnumConstraintMessage());
            this.putConstraintMessage(ConstraintType.VALIDATION_EXPRESSION, msgs.getValidationExpressionConstraintMessage());
            this.putConstraintMessage(ConstraintType.UNIQUE_ITEMS, msgs.getUniqueItemsConstraintMessage());
        }
        return this.constraintMessages;
    }

    private void putConstraintMessage(ConstraintType name, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.constraintMessages.put(name, value);
        }
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    @Override
    public BaseConstraint.Type getType() {
        return this.type;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    public String getValidationExpression() {
        return this.validationExpression;
    }

    private class ConstraintMessagesProvider
    implements ConstraintMessages {
        private static final String PN_TYPE_MESSAGE = "typeMessage";
        private static final String PN_REQUIRED_MESSAGE = "mandatoryMessage";
        private static final String PN_MINIMUM_MESSAGE = "minimumMessage";
        private static final String PN_MAXIMUM_MESSAGE = "maximumMessage";
        private static final String PN_MINLENGTH_MESSAGE = "minLengthMessage";
        private static final String PN_MAXLENGTH_MESSAGE = "maxLengthMessage";
        private static final String PN_MAXFILESIZE_MESSAGE = "maxFileSizeMessage";
        private static final String PN_ACCEPT_MESSAGE = "acceptMessage";
        private static final String PN_STEP_MESSAGE = "stepMessage";
        private static final String PN_FORMAT_MESSAGE = "formatMessage";
        private static final String PN_PATTERN_MESSAGE = "validatePictureClauseMessage";
        private static final String PN_MINITEMS_MESSAGE = "minItemsMessage";
        private static final String PN_MAXITEMS_MESSAGE = "maxItemsMessage";
        private static final String PN_UNIQUEITEMS_MESSAGE = "uniqueItemsMessage";
        private static final String PN_ENFORCEENUM_MESSAGE = "enforceEnumMessage";
        private static final String PN_VALIDATIONEXPRESSION_MESSAGE = "validateExpMessage";
        private ValueMap properties;

        private ConstraintMessagesProvider() {
            this.properties = AbstractBaseImpl.this.resource.getValueMap();
        }

        @Override
        @Nullable
        public String getTypeConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_TYPE_MESSAGE, (String)this.properties.get(PN_TYPE_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getRequiredConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_REQUIRED_MESSAGE, (String)this.properties.get(PN_REQUIRED_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getMinimumConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_MINIMUM_MESSAGE, (String)this.properties.get(PN_MINIMUM_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getMaximumConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_MAXIMUM_MESSAGE, (String)this.properties.get(PN_MAXIMUM_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getMinLengthConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_MINLENGTH_MESSAGE, (String)this.properties.get(PN_MINLENGTH_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getMaxLengthConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_MAXLENGTH_MESSAGE, (String)this.properties.get(PN_MAXLENGTH_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getMaxFileSizeConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_MAXFILESIZE_MESSAGE, (String)this.properties.get(PN_MAXFILESIZE_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getAcceptConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_ACCEPT_MESSAGE, (String)this.properties.get(PN_ACCEPT_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getStepConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_STEP_MESSAGE, (String)this.properties.get(PN_STEP_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getFormatConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_FORMAT_MESSAGE, (String)this.properties.get(PN_FORMAT_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getPatternConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_PATTERN_MESSAGE, (String)this.properties.get(PN_PATTERN_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getMinItemsConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_MINITEMS_MESSAGE, (String)this.properties.get(PN_MINITEMS_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getMaxItemsConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_MAXITEMS_MESSAGE, (String)this.properties.get(PN_MAXITEMS_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getUniqueItemsConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_UNIQUEITEMS_MESSAGE, (String)this.properties.get(PN_UNIQUEITEMS_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getEnforceEnumConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_ENFORCEENUM_MESSAGE, (String)this.properties.get(PN_ENFORCEENUM_MESSAGE, String.class));
        }

        @Override
        @Nullable
        public String getValidationExpressionConstraintMessage() {
            return AbstractBaseImpl.this.translate(PN_VALIDATIONEXPRESSION_MESSAGE, (String)this.properties.get(PN_VALIDATIONEXPRESSION_MESSAGE, String.class));
        }
    }

    private static interface ConstraintMessages {
        public String getTypeConstraintMessage();

        public String getRequiredConstraintMessage();

        public String getMinimumConstraintMessage();

        public String getMaximumConstraintMessage();

        public String getMinLengthConstraintMessage();

        public String getMaxLengthConstraintMessage();

        public String getMaxFileSizeConstraintMessage();

        public String getAcceptConstraintMessage();

        public String getStepConstraintMessage();

        public String getFormatConstraintMessage();

        public String getPatternConstraintMessage();

        public String getMinItemsConstraintMessage();

        public String getMaxItemsConstraintMessage();

        public String getUniqueItemsConstraintMessage();

        public String getEnforceEnumConstraintMessage();

        public String getValidationExpressionConstraintMessage();
    }
}

