/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.models.form;

import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

public enum FieldType {
    TEXT_INPUT("text-input"),
    EMAIL("email"),
    CAPTCHA("captcha"),
    MULTILINE_INPUT("multiline-input"),
    NUMBER_INPUT("number-input"),
    DATE_INPUT("date-input"),
    FILE_INPUT("file-input"),
    DROP_DOWN("drop-down"),
    RADIO_GROUP("radio-group"),
    PLAIN_TEXT("plain-text"),
    CHECKBOX("checkbox"),
    BUTTON("button"),
    PANEL("panel"),
    FORM("form"),
    CHECKBOX_GROUP("checkbox-group"),
    IMAGE("image");

    private String value;

    private FieldType(String value) {
        this.value = value;
    }

    public static FieldType fromString(String value) {
        for (FieldType type : FieldType.values()) {
            if (!StringUtils.equals((CharSequence)value, (CharSequence)type.value)) continue;
            return type;
        }
        return TEXT_INPUT;
    }

    public String getValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.value;
    }
}

