/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.models.form;

import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface BaseConstraint {
    @Nullable
    default public Boolean isRequired() {
        return null;
    }

    default public Type getType() {
        return Type.STRING;
    }

    @Nullable
    default public String getValidationExpression() {
        return null;
    }

    public static enum Type {
        STRING("string"),
        STRING_ARRAY("string[]"),
        NUMBER("number"),
        INTEGER("integer"),
        NUMBER_ARRAY("number[]"),
        BOOLEAN("boolean"),
        BOOLEAN_ARRAY("boolean[]"),
        OBJECT("object"),
        ARRAY("array"),
        FILE("file"),
        FILE_ARRAY("file[]");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String value) {
            for (Type type : Type.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)type.value)) continue;
                return type;
            }
            return STRING;
        }

        public String getValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

